/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.OptionalLong;
import javax.xml.validation.Schema;
import org.junit.Assert;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.api.ApiReference;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.deserializing.AttributesDeserializingStrategies;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.api.validation.ApiKitJsonSchema;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.validation.RestRequestValidator;
import org.mule.parser.service.ParserMode;
import org.mule.parser.service.ParserService;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;

public class TestRestRequestValidator {
    private String relativePath;
    private ParserMode parser;
    private ApiReference apiReference;
    private String charset;
    private Object body;
    private HttpRequestAttributes httpRequestAttributes;
    private ValidationConfig validationConfig;

    public TestRestRequestValidator(String relativePath, ParserMode parser, ApiReference apiReference, String charset, Object body, HttpRequestAttributes httpRequestAttributes, ValidationConfig validationConfig) {
        this.relativePath = relativePath;
        this.parser = parser;
        this.apiReference = apiReference;
        this.charset = charset;
        this.body = body;
        this.httpRequestAttributes = httpRequestAttributes;
        this.validationConfig = validationConfig != null ? validationConfig : new ValidationConfig(){

            public boolean isParserV2() {
                return true;
            }

            public ApiKitJsonSchema getJsonSchema(String schemaPath) {
                return null;
            }

            public Schema getXmlSchema(String schemaPath) {
                return null;
            }

            public ExpressionManager getExpressionManager() {
                return null;
            }

            public AttributesDeserializingStrategies getAttributesDeserializingStrategies() {
                return null;
            }
        };
    }

    public ValidRequest validateRequest() throws MuleRestException {
        URIResolver uriResolver = new URIResolver(this.relativePath);
        RoutingTable routingTable = new RoutingTable(new ParserService().parse(this.apiReference, this.parser).get());
        URIPattern pattern = uriResolver.find(routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
        Resource resource = routingTable.getResource(pattern);
        RestRequestValidator requestValidator = new RestRequestValidator(this.validationConfig, resource, null);
        return requestValidator.validate((ResolvedVariables)uriResolver.resolve(pattern), this.httpRequestAttributes, this.charset, this.body);
    }

    public <T extends Throwable> void assertThrows(Class<T> expectedThrowable, String containsMessage) {
        Throwable exception = Assert.assertThrows(expectedThrowable, () -> this.validateRequest());
        if (containsMessage != null) {
            String actual = exception.getMessage();
            Assert.assertTrue((boolean)actual.contains(containsMessage));
        }
    }

    public OptionalLong getRequestBodyLength() {
        return this.body instanceof TypedValue ? ((TypedValue)this.body).getByteLength() : OptionalLong.empty();
    }

    public RoutingTable getRoutingTable() {
        return this.apiReference != null && this.parser != null ? new RoutingTable(new ParserService().parse(this.apiReference, this.parser).get()) : null;
    }
}

