/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema;

import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.xml.validation.Schema;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.Resource;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.v1.RestJsonSchemaValidator;
import org.mule.runtime.api.exception.TypedException;
import org.raml.parser.visitor.SchemaCompiler;

public class RestJsonSchemaValidatorTestCase {
    private static final String jsonSchema = "{\n    \"$schema\" : \"http://json-schema.org/draft-03/schema\",\n    \"title\": \"League Schema\",\n    \"type\": \"object\",\n    \"properties\": {\n        \"id\": {\n            \"type\": \"string\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"required\": true\n        }\n    }\n}\n";
    private static ApiSpecification api;
    private static Action mockedAction;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final String VALIDATION_ERRORS_EXPECTED_MESSAGE = "error: object has missing required properties ([\"name\"])\n    level: \"error\"\n    schema: {\"loadingURI\":\"#\",\"pointer\":\"\"}\n    instance: {\"pointer\":\"\"}\n    domain: \"validation\"\n    keyword: \"properties\"\n    required: [\"name\"]\n    missing: [\"name\"]\n\nerror: instance type (integer) does not match any allowed primitive type (allowed: [\"string\"])\n    level: \"error\"\n    schema: {\"loadingURI\":\"#\",\"pointer\":\"/properties/id\"}\n    instance: {\"pointer\":\"/id\"}\n    domain: \"validation\"\n    keyword: \"type\"\n    found: \"integer\"\n    expected: [\"string\"]\n\n";

    @BeforeClass
    public static void mockApi() {
        api = (ApiSpecification)Mockito.mock(ApiSpecification.class);
        MimeType mimeType = (MimeType)Mockito.mock(MimeType.class);
        HashMap<String, Schema> compiledSchemaMap = new HashMap<String, Schema>();
        HashMap<String, MimeType> body = new HashMap<String, MimeType>();
        Schema compiledSchema = SchemaCompiler.getInstance().compile(jsonSchema);
        compiledSchemaMap.put("scheme-json", compiledSchema);
        Mockito.when((Object)api.getCompiledSchemas()).thenReturn(compiledSchemaMap);
        HashMap<String, String> schemaMap = new HashMap<String, String>();
        schemaMap.put("scheme-json", jsonSchema);
        Mockito.when((Object)api.getConsolidatedSchemas()).thenReturn(schemaMap);
        Mockito.when((Object)mimeType.getType()).thenReturn((Object)"application/json");
        Mockito.when((Object)mimeType.getSchema()).thenReturn((Object)"scheme-json");
        body.put("application/json", mimeType);
        mockedAction = (Action)Mockito.mock(Action.class);
        Mockito.when((Object)mockedAction.getBody()).thenReturn(body);
        Resource mockedResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockedResource.getAction("POST")).thenReturn((Object)mockedAction);
        Mockito.when((Object)mockedResource.getResolvedUri(api.getVersion())).thenReturn((Object)"/leagues");
        Mockito.when((Object)mockedAction.getResource()).thenReturn((Object)mockedResource);
        Mockito.when((Object)mockedAction.getType()).thenReturn((Object)ActionType.POST);
        Mockito.when((Object)api.getResource("/leagues")).thenReturn((Object)mockedResource);
    }

    @Test
    public void validStringPayloadUsingParser() throws TypedException, ExecutionException, BadRequestException {
        String payload = "{ \"name\": \"Major League Soccer\" }";
        RamlHandler ramlHandler = (RamlHandler)Mockito.mock(RamlHandler.class);
        Configuration config = new Configuration();
        Mockito.when((Object)ramlHandler.getApi()).thenReturn((Object)api);
        config.setRamlHandler(ramlHandler);
        RestJsonSchemaValidator JsonSchemavalidator = new RestJsonSchemaValidator(config.getJsonSchema("/leagues,POST,application/json").getSchema());
        JsonSchemavalidator.validate(payload);
    }

    @Test(expected=BadRequestException.class)
    public void invalidStringPayloadUsingParser() throws TypedException, BadRequestException, ExecutionException {
        String payload = "{ \"naazame\": \"Major League Soccer\" }";
        Configuration config = new Configuration();
        RamlHandler ramlHandler = (RamlHandler)Mockito.mock(RamlHandler.class);
        Mockito.when((Object)ramlHandler.getApi()).thenReturn((Object)api);
        config.setRamlHandler(ramlHandler);
        RestJsonSchemaValidator jsonSchemavalidator = new RestJsonSchemaValidator(config.getJsonSchema("/leagues,POST,application/json").getSchema());
        jsonSchemavalidator.validate(payload);
    }

    @Test
    public void showAllSchemaValidationErrors() throws TypedException, BadRequestException, ExecutionException {
        this.expectedException.expect(BadRequestException.class);
        this.expectedException.expectMessage(VALIDATION_ERRORS_EXPECTED_MESSAGE);
        String payload = "{ \"id\": 1 }";
        Configuration config = new Configuration();
        RamlHandler ramlHandler = (RamlHandler)Mockito.mock(RamlHandler.class);
        Mockito.when((Object)ramlHandler.getApi()).thenReturn((Object)api);
        config.setRamlHandler(ramlHandler);
        RestJsonSchemaValidator jsonSchemavalidator = new RestJsonSchemaValidator(config.getJsonSchema("/leagues,POST,application/json").getSchema());
        jsonSchemavalidator.validate(payload);
    }
}

