/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.runtime.api.exception.TypedException;

public class PayloadHelperTestCase {
    @Test
    public void validStreamPayload() throws TypedException, BadRequestException {
        ByteArrayInputStream is = new ByteArrayInputStream("{ \"name\": \"Major League Soccer\" }".getBytes());
        Assert.assertEquals((Object)"{ \"name\": \"Major League Soccer\" }", (Object)PayloadHelper.getPayloadAsString((Object)is, (String)"UTF-8"));
    }

    @Test
    public void validStringPayload() throws TypedException, BadRequestException {
        String payload = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><invalid>hello</invalid></league>";
        Assert.assertEquals((Object)payload, (Object)PayloadHelper.getPayloadAsString((Object)payload, (String)"UTF-8"));
    }

    @Test
    public void validInputStreamPayload() throws TypedException, BadRequestException {
        String payloadString = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><invalid>hello</invalid></league>";
        ByteArrayInputStream payloadStream = new ByteArrayInputStream(payloadString.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)payloadString, (Object)PayloadHelper.getPayloadAsString((Object)payloadStream, (String)"UTF-8"));
    }

    @Test
    public void validRewindableInputStreamPayload() throws TypedException, BadRequestException {
        String payloadString = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><invalid>hello</invalid></league>";
        ByteArrayInputStream payloadStream = new ByteArrayInputStream(payloadString.getBytes(StandardCharsets.UTF_8));
        RewindableInputStream rewindable = new RewindableInputStream((InputStream)payloadStream);
        Assert.assertEquals((Object)payloadString, (Object)PayloadHelper.getPayloadAsString((Object)rewindable, (String)"UTF-8"));
        Assert.assertEquals((Object)payloadString, (Object)PayloadHelper.getPayloadAsString((Object)rewindable, (String)"UTF-8"));
    }

    @Test
    public void validBytesPayload() throws TypedException, BadRequestException {
        byte[] payload = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><invalid>hello</invalid></league>".getBytes();
        Assert.assertEquals((Object)"<league xmlns=\"http://mulesoft.com/schemas/soccer\"><invalid>hello</invalid></league>", (Object)PayloadHelper.getPayloadAsString((Object)payload, (String)"UTF-8"));
    }

    @Test(expected=BadRequestException.class)
    public void nullPayload() throws TypedException, BadRequestException {
        PayloadHelper.getPayloadAsString(null, (String)"UTF-8");
    }

    @Test
    public void validStreamPayloadWithBOM() throws TypedException, BadRequestException {
        String utf8BOM = "\ufeff";
        String payload = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><greeting>hello</greeting></league>";
        Assert.assertThat((Object)"<league xmlns=\"http://mulesoft.com/schemas/soccer\"><greeting>hello</greeting></league>", (Matcher)CoreMatchers.is((Object)PayloadHelper.getPayloadAsString((Object)"\ufeff<league xmlns=\"http://mulesoft.com/schemas/soccer\"><greeting>hello</greeting></league>", (String)"UTF-8")));
    }

    @Test(expected=BadRequestException.class)
    public void unknownPayloadClass() throws Exception {
        PayloadHelper.getPayloadAsString((Object)new UnknownPayload(), (String)"UTF-8");
    }

    public class UnknownPayload {
    }
}

