/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.util.MultiMap;

public class QueryValidatorConsistencyTestCase
extends AbstractRequestValidatorTestCase {
    private static final String STRING_ITEM_PARAM = "stringItemParam";
    private static final String NUMERIC_ITEM_PARAM = "numericItemParam";
    private static final String INTEGER_ITEM_PARAM = "integerItemParam";
    private static final String BOOLEAN_ITEM_PARAM = "booleanItemParam";
    private static final String DATETIME_ITEM_PARAM = "datetimeItemParam";
    private static final String UNION_ITEM_PARAM = "unionItemParam";
    private static final String OBJECT_ITEM_PARAM = "objectItemParam";
    private static final String STRING_ITEM_PARAMS = "stringItemParams";
    private static final String NUMERIC_ITEM_PARAMS = "numericItemParams";
    private static final String INTEGER_ITEM_PARAMS = "integerItemParams";
    private static final String BOOLEAN_ITEM_PARAMS = "booleanItemParams";
    private static final String DATETIME_ITEM_PARAMS = "datetimeItemParams";
    private static final String OBJECT_ITEM_PARAMS = "objectItemParams";
    private static final String NULLABLE_UNION_OF_ARRAYS = "nullableUnionOfArraysParams";
    private static final String NON_NULLABLE_UNION_OF_ARRAYS = "nonNullableUnionOfArraysParams";
    private static final String NULLABLE_UNION_OF_NULLABLE_ARRAYS = "nullableUnionOfNullableArraysParams";
    private static final String NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS = "nonNullableUnionOfNullableArraysParams";
    private List<String> nullList;

    private List<String> getNullList() {
        this.nullList = new ArrayList<String>();
        this.nullList.add(null);
        this.nullList.add(null);
        return this.nullList;
    }

    private List<String> getStringNullList() {
        this.nullList = new ArrayList<String>();
        this.nullList.add("null");
        this.nullList.add("null");
        return this.nullList;
    }

    @Test
    public void validateString() throws MuleRestException {
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAM, Arrays.asList("ABC"));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAM, Arrays.asList("123"));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAM, Arrays.asList("\"123\""));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAM, Arrays.asList("A\"B\"C"));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAM, Arrays.asList("\"ABC\""));
        this.assertConsistencyOnFail(STRING_ITEM_PARAM, Arrays.asList("exceedsMaxLength"));
        this.assertConsistencyOnFail(STRING_ITEM_PARAM, Arrays.asList("\"1234\""));
    }

    @Test
    public void validateNumber() throws MuleRestException {
        this.assertConsistencyOnSuccess(NUMERIC_ITEM_PARAM, Arrays.asList("123.12"));
        this.assertConsistencyOnSuccess(NUMERIC_ITEM_PARAM, Arrays.asList("123"));
        this.assertConsistencyOnSuccess(NUMERIC_ITEM_PARAM, Arrays.asList("00000123"));
        this.assertConsistencyOnFail(NUMERIC_ITEM_PARAM, Arrays.asList("\"123\""));
    }

    @Test
    public void validateInteger() throws MuleRestException {
        this.assertConsistencyOnSuccess(INTEGER_ITEM_PARAM, Arrays.asList("123"));
        this.assertConsistencyOnFail(INTEGER_ITEM_PARAM, Arrays.asList("12.34"));
    }

    @Test
    public void validateBoolean() throws MuleRestException {
        this.assertConsistencyOnSuccess(BOOLEAN_ITEM_PARAM, Arrays.asList("false"));
        this.assertConsistencyOnSuccess(BOOLEAN_ITEM_PARAM, Arrays.asList("True"));
        this.assertConsistencyOnFail(BOOLEAN_ITEM_PARAM, Arrays.asList("ABC"));
    }

    @Test
    public void validateDatetime() throws MuleRestException {
        this.assertConsistencyOnSuccess(DATETIME_ITEM_PARAM, Arrays.asList("2016-02-28T16:41:41.090Z"));
        this.assertConsistencyOnFail(DATETIME_ITEM_PARAM, Arrays.asList("12016-02-28T16:41:41.090Z"));
    }

    @Test
    public void validateUnion() throws MuleRestException {
        this.assertConsistencyOnSuccess(UNION_ITEM_PARAM, Arrays.asList("ABC"));
        this.assertConsistencyOnSuccess(UNION_ITEM_PARAM, Arrays.asList("123"));
        this.assertConsistencyOnSuccess(UNION_ITEM_PARAM, Arrays.asList("{\"someField\": \"someValue\"}"));
        this.assertConsistencyOnSuccess(UNION_ITEM_PARAM, Arrays.asList("\n- \"firstValue\"\n- \"secondValue\"\n"));
    }

    @Test
    public void validateObject() throws MuleRestException {
        this.assertConsistencyOnSuccess(OBJECT_ITEM_PARAM, Arrays.asList("{\"stringProp\":\"test\",\"numberProp\":0.10,\"integerProp\":3,\"booleanProp\":false,\"datetimeProp\":\"2016-02-28T16:41:41.090Z\",\"stringProps\":[\"A\",\"B\"],\"numberProps\":[0,1.26],\"integerProps\": [0, 1, 2],\"booleanProps\":[false,true,true],\"datetimeProps\":[\"2016-02-28T16:41:41.090Z\",\"2016-02-28T16:41:41.090Z\"]}"));
        this.assertConsistencyOnFail(OBJECT_ITEM_PARAM, Arrays.asList("{\"integerProp\":3.4}"));
    }

    @Test
    public void validateStingArray() throws MuleRestException {
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAMS, Arrays.asList("ABC", "DEF"));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAMS, Arrays.asList("123", "456"));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAMS, Arrays.asList("A\"B\"C", "D\"E\"F"));
        this.assertConsistencyOnSuccess(STRING_ITEM_PARAMS, Arrays.asList("\"ABC\"", "\"DEF\""));
        this.assertConsistencyOnFail(STRING_ITEM_PARAMS, Arrays.asList("ABC", "exceedsMaxLength"));
    }

    @Test
    public void validateNumberArray() throws MuleRestException {
        this.assertConsistencyOnSuccess(NUMERIC_ITEM_PARAMS, Arrays.asList("123.34", "456.67"));
        this.assertConsistencyOnSuccess(NUMERIC_ITEM_PARAMS, Arrays.asList("123", "456"));
        this.assertConsistencyOnFail(NUMERIC_ITEM_PARAMS, Arrays.asList("123", "ABC"));
    }

    @Test
    public void validateIntegerArray() throws MuleRestException {
        this.assertConsistencyOnSuccess(INTEGER_ITEM_PARAMS, Arrays.asList("123", "456"));
        this.assertConsistencyOnFail(INTEGER_ITEM_PARAMS, Arrays.asList("123", "45.67"));
    }

    @Test
    public void validateBooleanArray() throws MuleRestException {
        this.assertConsistencyOnSuccess(BOOLEAN_ITEM_PARAMS, Arrays.asList("false", "True"));
        this.assertConsistencyOnFail(BOOLEAN_ITEM_PARAMS, Arrays.asList("false", "ABC"));
    }

    @Test
    public void validateDatetimeArray() throws MuleRestException {
        this.assertConsistencyOnSuccess(DATETIME_ITEM_PARAMS, Arrays.asList("2016-02-28T16:41:41.090Z", "2018-08-25T16:41:41.090Z"));
        this.assertConsistencyOnFail(DATETIME_ITEM_PARAMS, Arrays.asList("12016-02-28T16:41:41.090Z", "2018-08-25T16:41:41.090Z"));
    }

    @Test
    public void validateObjectArray() throws MuleRestException {
        this.assertConsistencyOnSuccess(OBJECT_ITEM_PARAMS, Arrays.asList("{\"stringProp\":\"test\",\"numberProp\":0.10,\"integerProp\":3,\"booleanProp\":false,\"datetimeProp\":\"2016-02-28T16:41:41.090Z\",\"stringProps\":[\"A\",\"B\"],\"numberProps\":[0,1.26],\"integerProps\": [0, 1, 2],\"booleanProps\":[false,true,true],\"datetimeProps\":[\"2016-02-28T16:41:41.090Z\",\"2016-02-28T16:41:41.090Z\"]}", "{\"stringProp\":\"test2\",\"numberProp\":1.23,\"integerProp\":4,\"booleanProp\":True,\"datetimeProp\":\"2016-02-28T16:41:41.090Z\",\"stringProps\":[\"C\",\"D\"],\"numberProps\":[56,242.66],\"integerProps\":[3,4,5],\"booleanProps\":[true,false,true],\"datetimeProps\":[\"2016-02-28T16:41:41.090Z\",\"2016-02-28T16:41:41.090Z\"]}"));
        this.assertConsistencyOnFail(OBJECT_ITEM_PARAMS, Arrays.asList("{\"integerProp\":3.4}", "{\"stringProp\":\"test2\"}"));
    }

    @Test
    public void validateNullableUnionArraysParams() throws MuleRestException {
        if (this.parser.equals((Object)ParserMode.AMF)) {
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_ARRAYS, Arrays.asList("123", "456"));
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_ARRAYS, Arrays.asList("true", "false"));
            this.assertConsistencyOnFail(NULLABLE_UNION_OF_ARRAYS, Arrays.asList("true", "123"));
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_ARRAYS, null);
            this.assertConsistencyOnFail(NULLABLE_UNION_OF_ARRAYS, this.getNullList());
            this.assertConsistencyOnFail(NULLABLE_UNION_OF_ARRAYS, this.getStringNullList());
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_ARRAYS, Collections.singletonList(null));
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_ARRAYS, Collections.singletonList("null"));
        }
    }

    @Test
    public void validateNullableUnionNullableArraysParams() throws MuleRestException {
        if (this.parser.equals((Object)ParserMode.AMF)) {
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_NULLABLE_ARRAYS, Arrays.asList("abc", "def"));
            this.assertConsistencyOnFail(NULLABLE_UNION_OF_NULLABLE_ARRAYS, Arrays.asList("true", "false"));
            this.assertConsistencyOnFail(NULLABLE_UNION_OF_NULLABLE_ARRAYS, Arrays.asList("true", "123"));
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_NULLABLE_ARRAYS, null);
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_NULLABLE_ARRAYS, this.getNullList());
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_NULLABLE_ARRAYS, this.getStringNullList());
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_NULLABLE_ARRAYS, Collections.singletonList(null));
            this.assertConsistencyOnSuccess(NULLABLE_UNION_OF_NULLABLE_ARRAYS, Collections.singletonList("null"));
        }
    }

    @Test
    public void validateNonNullableUnionArraysParams() throws MuleRestException {
        if (this.parser.equals((Object)ParserMode.AMF)) {
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_ARRAYS, Arrays.asList("123", "456"));
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_ARRAYS, Arrays.asList("true", "false"));
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_ARRAYS, Arrays.asList("true", "123"));
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_ARRAYS, null);
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_ARRAYS, this.getNullList());
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_ARRAYS, this.getStringNullList());
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_ARRAYS, Collections.singletonList(null));
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_ARRAYS, Collections.singletonList("null"));
        }
    }

    @Test
    public void validateNonNullableUnionNullableArraysParams() throws MuleRestException {
        if (this.parser.equals((Object)ParserMode.AMF)) {
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, Arrays.asList("abc", "def"));
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, Arrays.asList("true", "false"));
            this.assertConsistencyOnFail(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, Arrays.asList("true", "123"));
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, null);
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, this.getNullList());
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, this.getStringNullList());
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, Collections.singletonList(null));
            this.assertConsistencyOnSuccess(NON_NULLABLE_UNION_OF_NULLABLE_ARRAYS, Collections.singletonList("null"));
        }
    }

    @Test
    public void validateEmpty() throws MuleRestException {
        MultiMap queryParams = MultiMap.emptyMultiMap();
        String queryString = "";
        this.validateRequest((MultiMap<String, String>)queryParams, queryString, "/testQueryString");
        this.validateRequest((MultiMap<String, String>)queryParams, queryString, "/testQueryParams");
    }

    @Test
    public void invalidDefaultValueInSpecIsNotBeingValidatedForQueryString() throws MuleRestException {
        MultiMap queryParams = MultiMap.emptyMultiMap();
        String queryString = "";
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-consistency/invalid-default.raml").withMethod("GET").withRelativePath("/testQueryString").withQueryParams((MultiMap<String, String>)queryParams).withQueryString(queryString).build().validateRequest();
    }

    @Test
    public void invalidDefaultValueInSpecIsNotBeingValidatedForQueryParams() throws MuleRestException {
        MultiMap queryParams = MultiMap.emptyMultiMap();
        String queryString = "";
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-consistency/invalid-default.raml").withMethod("GET").withRelativePath("/testQueryParams").withQueryParams((MultiMap<String, String>)queryParams).withQueryString(queryString).build().validateRequest();
    }

    private void assertConsistencyOnSuccess(String queryName, List<String> queryValues) throws MuleRestException {
        MultiMap<String, String> queryParams = this.getQueryParams(queryName, queryValues);
        String queryString = this.getQueryString(queryName, queryValues);
        this.validateRequest(queryParams, queryString, "/testQueryString");
        this.validateRequest(queryParams, "", "/testQueryParams");
    }

    private void assertConsistencyOnFail(String queryName, List<String> queryValues) {
        MultiMap<String, String> queryParams = this.getQueryParams(queryName, queryValues);
        String queryString = this.getQueryString(queryName, queryValues);
        Assert.assertThrows(MuleRestException.class, () -> this.validateRequest(queryParams, queryString, "/testQueryString"));
        Assert.assertThrows(MuleRestException.class, () -> this.validateRequest(queryParams, "", "/testQueryParams"));
    }

    private MultiMap<String, String> getQueryParams(String queryName, List<String> queryValues) {
        MultiMap queryParams = new MultiMap();
        if (queryValues == null) {
            queryParams.put((Object)queryName, (Object)null);
            return queryParams;
        }
        queryValues.forEach(v -> {
            String cfr_ignored_0 = (String)queryParams.put((Object)queryName, v);
        });
        return queryParams;
    }

    private String getQueryString(String queryName, List<String> queryValues) {
        if (queryValues == null) {
            return "";
        }
        String queryString = queryName + "=" + queryValues.stream().filter(v -> v != null).map(v -> {
            try {
                return URLEncoder.encode(v, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return v;
            }
        }).collect(Collectors.joining("&" + queryName + "="));
        return queryString;
    }

    private void validateRequest(MultiMap<String, String> queryParams, String queryString, String relativePath) throws MuleRestException {
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-consistency/api.raml").withMethod("GET").withRequestPath("/api" + relativePath).withRelativePath(relativePath).withQueryParams(queryParams).withQueryString(queryString).build().validateRequest();
    }
}

