/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.mule.apikit.model.api.ApiReference;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.validation.TestRestRequestValidator;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;

public class TestRestRequestValidatorBuilder {
    private HttpRequestAttributesBuilder httpRequestAttributesBuilder = new HttpRequestAttributesBuilder().listenerPath("/api/*").version("1").scheme("http").requestUri("/").rawRequestUri("/").localAddress("").queryString("").remoteAddress("");
    private String apiLocation;
    private String method;
    private String relativePath;
    private String requestPath;
    private String rawRequestPath;
    private String charset;
    private Object body;
    private ValidationConfig validationConfig;
    private ParserMode parser;

    public TestRestRequestValidatorBuilder withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public TestRestRequestValidatorBuilder withRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public TestRestRequestValidatorBuilder withRawRequestPath(String rawRequestPath) {
        this.rawRequestPath = rawRequestPath;
        return this;
    }

    public TestRestRequestValidatorBuilder withMethod(String method) {
        this.method = method;
        return this;
    }

    public TestRestRequestValidatorBuilder withQueryParams(MultiMap<String, String> queryParams) {
        this.httpRequestAttributesBuilder.queryParams(queryParams);
        return this;
    }

    public TestRestRequestValidatorBuilder withQueryString(String queryString) {
        this.httpRequestAttributesBuilder.queryString(queryString);
        return this;
    }

    public TestRestRequestValidatorBuilder withUriParams(MultiMap<String, String> uriParams) {
        this.httpRequestAttributesBuilder.uriParams(uriParams);
        return this;
    }

    public TestRestRequestValidatorBuilder withListenerPath(String listenerPath) {
        this.httpRequestAttributesBuilder.listenerPath(listenerPath);
        return this;
    }

    public TestRestRequestValidatorBuilder withHeaders(MultiMap<String, String> headers) {
        this.httpRequestAttributesBuilder.headers(headers);
        return this;
    }

    public TestRestRequestValidatorBuilder withApiLocation(String apiLocation) {
        this.apiLocation = apiLocation;
        return this;
    }

    public TestRestRequestValidatorBuilder withValidationConfig(ValidationConfig validationConfig) {
        this.validationConfig = validationConfig;
        return this;
    }

    public TestRestRequestValidatorBuilder withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public TestRestRequestValidatorBuilder withBody(String body) {
        this.body = new ByteArrayInputStream(body.getBytes());
        return this;
    }

    public TestRestRequestValidatorBuilder withBody(TypedValue typedValue) {
        this.body = typedValue;
        return this;
    }

    public TestRestRequestValidatorBuilder withCharset(String payloadCharset) {
        this.charset = payloadCharset;
        return this;
    }

    public TestRestRequestValidatorBuilder withParser(ParserMode parser) {
        this.parser = parser;
        return this;
    }

    public TestRestRequestValidator build() {
        this.validateMandatory();
        this.setDefaults();
        HttpRequestAttributes httpRequestAttributes = this.httpRequestAttributesBuilder.method(this.method).relativePath(this.relativePath).requestPath(this.requestPath).rawRequestPath(this.rawRequestPath).build();
        return new TestRestRequestValidator(this.relativePath, this.parser, ApiReference.create((String)this.apiLocation), this.charset, this.body, httpRequestAttributes, this.validationConfig);
    }

    private void validateMandatory() {
        Assert.assertNotNull((String)"API location is mandatory for the test to run", (Object)this.apiLocation);
        Assert.assertNotNull((String)"Relative path is mandatory for the test to run", (Object)this.relativePath);
        Assert.assertNotNull((String)"Method is mandatory for the test to run", (Object)this.method);
    }

    private void setDefaults() {
        this.parser = this.parser != null ? this.parser : ParserMode.AMF;
        this.requestPath = this.requestPath != null ? this.requestPath : "/api" + this.relativePath;
        this.rawRequestPath = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.rawRequestPath}) ? this.rawRequestPath : this.requestPath;
    }
}

