/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.module.apikit.validation.TestRestRequestValidatorBuilder;
import org.mule.runtime.api.util.MultiMap;

public class PayloadWithoutMimeTypeValidationTestCase
extends AbstractRequestValidatorTestCase {
    private static final String VALID_XML = "<User><id>1</id><name>name</name></User>";
    private static final String INVALID_XML = "<User><id1>1</id1><name>name</name></User>";
    private static final String VALID_JSON = "{\"id\":1, \"name\":\"test\"}";
    private static final String INVALID_JSON = "{\"id1\":1, \"name\":\"test\"}";
    private TestRestRequestValidatorBuilder withSchemaRequestBuilder;

    @Before
    public void setUp() {
        this.withSchemaRequestBuilder = this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/oas20-payload-without-mimetype.yaml").withRelativePath("/withSchema").withMethod("POST");
    }

    @Test
    public void invalidJsonWithSchemaAndWithoutMimeTypeTest() throws Exception {
        if (this.parser.name().equals("RAML")) {
            return;
        }
        this.withSchemaRequestBuilder.withHeaders((MultiMap<String, String>)new MultiMap(Collections.singletonMap("Content-Type", "application/json"))).withBody(INVALID_JSON).build().assertThrows(BadRequestException.class, "required key [id] not found");
    }

    @Test
    public void validJsonWithSchemaAndWithoutMimeTypeTest() throws Exception {
        if (this.parser.name().equals("RAML")) {
            return;
        }
        this.withSchemaRequestBuilder.withBody(VALID_JSON).withHeaders((MultiMap<String, String>)new MultiMap(Collections.singletonMap("Content-Type", "application/json"))).build().validateRequest();
    }

    @Test
    public void validXMLWithSchemaAndWithoutMimeTypeTest() throws Exception {
        if (this.parser.name().equals("RAML")) {
            return;
        }
        this.withSchemaRequestBuilder.withBody(VALID_XML).withHeaders((MultiMap<String, String>)new MultiMap(Collections.singletonMap("Content-Type", "application/xml"))).build().validateRequest();
    }

    @Test
    public void invalidXMLWithSchemaAndWithoutMimeTypeTest() throws Exception {
        if (this.parser.name().equals("RAML")) {
            return;
        }
        this.withSchemaRequestBuilder.withBody(INVALID_XML).withHeaders((MultiMap<String, String>)new MultiMap(Collections.singletonMap("Content-Type", "application/xml"))).build().assertThrows(BadRequestException.class, "The content of element 'User' is not complete");
    }

    @Test
    public void withoutSchemaAndWithoutMimeTypeTest() throws Exception {
        if (this.parser.name().equals("RAML")) {
            return;
        }
        TestRestRequestValidatorBuilder withoutSchemaRequestBuilder = this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/oas20-payload-without-mimetype.yaml").withRelativePath("/withoutSchema").withMethod("POST");
        withoutSchemaRequestBuilder.withBody(INVALID_JSON).build().validateRequest();
        withoutSchemaRequestBuilder.withBody(VALID_JSON).build().validateRequest();
        withoutSchemaRequestBuilder.withBody(INVALID_XML).build().validateRequest();
        withoutSchemaRequestBuilder.withBody(VALID_XML).build().validateRequest();
        withoutSchemaRequestBuilder.withBody("any").build().validateRequest();
    }
}

