/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.module.apikit.validation.TestRestRequestValidatorBuilder;
import org.mule.runtime.api.util.MultiMap;

public class UnionXMLBodyTestCase
extends AbstractRequestValidatorTestCase {
    public static final String AMF_VALIDATE_UNION_PROPERTY = "amf.plugins.xml.validateUnion";
    private TestRestRequestValidatorBuilder testBuilder;

    @Before
    public void before() {
        System.setProperty(AMF_VALIDATE_UNION_PROPERTY, "true");
        this.testBuilder = this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/xml-union-types-api.raml").withMethod("POST").withHeaders((MultiMap<String, String>)new MultiMap(Collections.singletonMap("Content-Type", "application/xml")));
    }

    @Test
    public void xmlUnionTest() throws MuleRestException {
        this.testBuilder.withRelativePath("/xmlUnion");
        if (this.parser.name().equals("RAML")) {
            String validForRamlParser = "<unionElement><message1>test</message1></unionElement>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForRamlParser.getBytes())).build().validateRequest();
        } else {
            String validForAmfParser = "<unionElement><message1>test</message1></unionElement>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForAmfParser.getBytes())).build().validateRequest();
        }
    }

    @Test
    public void xmlUnionInlineTest() throws MuleRestException {
        this.testBuilder.withRelativePath("/xmlUnionInline");
        if (this.parser.name().equals("RAML")) {
            String validForRamlParser = "<root><message1>test</message1></root>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForRamlParser.getBytes())).build().validateRequest();
        } else {
            String validForAmfParser = "<model><message2>test</message2></model>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForAmfParser.getBytes())).build().validateRequest();
        }
    }

    @Test
    public void xmlUnionInlineWithSerializationPropertiesTest() throws MuleRestException {
        this.testBuilder.withRelativePath("/xmlUnionInlineWithSerializationProperties");
        if (this.parser.name().equals("RAML")) {
            String validForRamlParser = "<root><message1>test</message1></root>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForRamlParser.getBytes())).build().validateRequest();
        } else {
            String validForAmfParser = "<someName xmlns=\"http://test.namespace.com\"><message1>test</message1></someName>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForAmfParser.getBytes())).build().validateRequest();
        }
    }

    @Test
    public void invalidXmlUnionTest() {
        this.testBuilder.withRelativePath("/xmlUnion");
        if (this.parser.name().equals("RAML")) {
            String validForRamlParser = "<unionElement><message2>test</message2></unionElement>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForRamlParser.getBytes())).build().assertThrows(BadRequestException.class, "One of '{\"http://validationnamespace.raml.org\":message1}' is expected.");
        } else {
            String validForAmfParser = "<unionElement><message3>test</message3></unionElement>";
            this.testBuilder.withBody(new ByteArrayInputStream(validForAmfParser.getBytes())).build().assertThrows(BadRequestException.class, "One of '{\"http://amf-xml-extension/\":message1, \"http://amf-xml-extension/\":message2}' is expected");
        }
    }

    @After
    public void after() {
        System.clearProperty(AMF_VALIDATE_UNION_PROPERTY);
    }
}

