/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataTextParameter;

public class MultipartFormDataTextParameterTestCase {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void validateInvalidParameter() throws InvalidFormParameterException {
        this.expectedEx.expect(InvalidFormParameterException.class);
        this.expectedEx.expectMessage("invalid value");
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter.validate((String)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)parameter.message((String)ArgumentMatchers.any())).thenReturn((Object)"invalid value");
        MultipartFormDataTextParameter textParameter = new MultipartFormDataTextParameter("invalid body");
        textParameter.validate(parameter);
    }

    @Test
    public void validateValidParameter() throws InvalidFormParameterException {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter.validate((String)ArgumentMatchers.any())).thenReturn((Object)true);
        MultipartFormDataTextParameter textParameter = new MultipartFormDataTextParameter("valid body");
        textParameter.validate(parameter);
    }

    @Test
    public void validateValidArrayParameter() throws InvalidFormParameterException {
        MultipartFormDataTextParameter formDataTextParameter = new MultipartFormDataTextParameter("[123,123]");
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter.isArray()).thenReturn((Object)true);
        Mockito.when((Object)parameter.validateArray(ArgumentMatchers.anyCollection())).thenReturn((Object)true);
        formDataTextParameter.validate(parameter);
    }
}

