/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.OptionalLong;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.mule.module.apikit.validation.TestRestRequestValidator;
import org.mule.module.apikit.validation.TestRestRequestValidatorBuilder;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;

public class MultipartTestBuilder {
    private final MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
    private final TestRestRequestValidatorBuilder testRestRequestValidatorBuilder = new TestRestRequestValidatorBuilder();

    MultipartTestBuilder withTextPart(String name, String content) {
        this.multipartEntityBuilder.addTextBody(name, content);
        return this;
    }

    MultipartTestBuilder withApiLocation(String apiLocation) {
        this.testRestRequestValidatorBuilder.withApiLocation(apiLocation);
        return this;
    }

    MultipartTestBuilder withRelativePath(String relativePath) {
        this.testRestRequestValidatorBuilder.withRelativePath(relativePath);
        return this;
    }

    public MultipartTestBuilder withParser(ParserMode parser) {
        this.testRestRequestValidatorBuilder.withParser(parser);
        return this;
    }

    public TestRestRequestValidator build() {
        HttpEntity multipart = this.multipartEntityBuilder.build();
        String contentType = multipart.getContentType().getValue();
        TypedValue typedValue = MultipartTestBuilder.getTypedValue(multipart, contentType);
        return this.testRestRequestValidatorBuilder.withMethod("POST").withHeaders((MultiMap<String, String>)new MultiMap(Collections.singletonMap("Content-Type", contentType))).withBody(typedValue).build();
    }

    private static TypedValue getTypedValue(HttpEntity multipart, String contentType) {
        MediaType mediaType = MediaType.parse((String)contentType);
        InMemoryCursorStreamProvider cursorProvider = new InMemoryCursorStreamProvider(MultipartTestBuilder.getContent(multipart), InMemoryCursorStreamConfig.getDefault(), (ByteBufferManager)new DummyByteBufferManager());
        DataType dataType = DataType.builder((DataType)DataType.CURSOR_STREAM_PROVIDER).mediaType(mediaType).build();
        TypedValue typedValue = new TypedValue((Object)cursorProvider, dataType, OptionalLong.of(multipart.getContentLength()));
        return typedValue;
    }

    private static InputStream getContent(HttpEntity multipart) {
        try {
            return multipart.getContent();
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating multipart content", e);
        }
    }

    private static class DummyByteBufferManager
    implements ByteBufferManager {
        private DummyByteBufferManager() {
        }

        public ByteBuffer allocate(int capacity) {
            return ByteBuffer.allocate(capacity);
        }

        public void deallocate(ByteBuffer byteBuffer) {
        }
    }
}

