/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataBinaryParameter;
import org.mule.runtime.api.metadata.MediaType;

public class MultipartWithDefaultsBinaryParameterTestCase {
    @Test(expected=InvalidFormParameterException.class)
    public void invalidContentType() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "image/png");
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void parameterWithoutFileProperties() throws Exception {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter.getFileProperties()).thenReturn(Optional.empty());
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void validContentTypeAndNoSizeRestriction() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "image/png", "image/jpeg");
        this.validate(parameter, "image/jpeg");
    }

    @Test(expected=InvalidFormParameterException.class)
    public void sizeLowerThanMinLength() throws Exception {
        Parameter parameter = this.getParameter(16, 20, "image/png", "image/jpeg");
        this.validate(parameter, "image/jpeg");
    }

    @Test(expected=InvalidFormParameterException.class)
    public void sizeBiggerThanMaxLength() throws Exception {
        Parameter parameter = this.getParameter(10, 14, "image/png", "image/jpeg");
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void validSize() throws Exception {
        Parameter parameter = this.getParameter(15, 15, "image/png", "image/jpeg");
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void anyFileTypeAllowed() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "*/*");
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void emptyFileTypes() throws Exception {
        Parameter parameter = this.getParameter(0, 0, new String[0]);
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void subtypeWildcard() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "image/*");
        this.validate(parameter, "image/jpeg");
    }

    @Test
    public void extraParametersAreIgnored() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "text/plain");
        this.validate(parameter, "text/plain; charset=utf8");
    }

    @Test
    public void parameterQuotingIsIgnored() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "text/plain; my-param=\"my-value\"; another-param=another-value");
        this.validate(parameter, "text/plain; my-param=my-value; another-param=\"another-value\"");
    }

    @Test
    public void parameterOrderIsNotImportant() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "text/plain; a=b; b=c");
        this.validate(parameter, "text/plain; b=c; a=b");
    }

    @Test
    public void parametersAreValidatedAsRequired() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "text/plain; myParam=test");
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "text/plain"));
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "text/plain; myparam=toast"));
        this.validate(parameter, "text/plain; myparam=\"test\"");
    }

    @Test
    public void charsetParametersAreValidatedRespectingAliases() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "text/plain; charset=utf8");
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "text/plain"));
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "text/plain; charset=ascii"));
        this.validate(parameter, "text/plain; CharSet=\"utf8\"");
        this.validate(parameter, "text/plain; CharSet=\"utf-8\"");
        this.validate(parameter, "text/plain; CharSet=\"UTF-8\"");
    }

    @Test
    public void wildcardTypesValidateParameters() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "*/*; loves-mule=yes");
        this.validate(parameter, "text/plain; loves-mule=yes");
        this.validate(parameter, "image/png; loves-mule=yes; extra-param=ignored");
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "text/plain; loves-mule=no"));
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "image/png"));
    }

    @Test
    public void wildcardSubtypesValidateParameters() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "image/*; loves-mule=yes");
        this.validate(parameter, "image/webp; loves-mule=yes");
        this.validate(parameter, "image/png; loves-mule=yes; extra-param=ignored");
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "image/webp; loves-mule=no"));
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "image/png"));
        Assert.assertThrows(InvalidFormParameterException.class, () -> this.validate(parameter, "text/plain; loves-mule=yes"));
    }

    @Test(expected=InvalidFormParameterException.class)
    public void illegalCharsetsFailValidation() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "text/plain; charset=invalid-charset!");
        this.validate(parameter, "text/plain; charset=ascii");
    }

    @Test(expected=InvalidFormParameterException.class)
    public void illegalMimeFailValidation() throws Exception {
        Parameter parameter = this.getParameter(0, 0, "this is not a valid mime!");
        this.validate(parameter, "text/plain; charset=ascii");
    }

    private Parameter getParameter(int minLength, int maxLength, String ... mediaTypes) {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        FileProperties properties = new FileProperties(Integer.valueOf(minLength), Integer.valueOf(maxLength), (Set)ImmutableSet.copyOf((Object[])mediaTypes));
        Mockito.when((Object)parameter.getFileProperties()).thenReturn(Optional.of(properties));
        return parameter;
    }

    private void validate(Parameter parameter, String mediaType) throws InvalidFormParameterException {
        MultipartFormDataBinaryParameter parameterValidator = new MultipartFormDataBinaryParameter("testing payload".getBytes().length, MediaType.parse((String)mediaType));
        parameterValidator.validate(parameter);
    }
}

