/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema;

import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.xml.validation.Schema;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.Resource;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.v1.RestXmlSchemaValidator;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.message.ErrorType;
import org.raml.parser.visitor.SchemaCompiler;

public class RestXMLSchemaValidatorTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final String xmlSchema = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" xmlns=\"http://mulesoft.com/schemas/soccer\" targetNamespace=\"http://mulesoft.com/schemas/soccer\"><xs:element name=\"league\">  <xs:complexType>    <xs:sequence>      <xs:element name=\"name\" type=\"xs:string\"/>      <xs:element name=\"description\" type=\"xs:string\" minOccurs=\"0\"/>    </xs:sequence>  </xs:complexType></xs:element></xs:schema>";
    private static ApiSpecification api;

    @BeforeClass
    public static void mockApi() {
        api = (ApiSpecification)Mockito.mock(ApiSpecification.class);
        HashMap<String, Schema> compiledSchemaMap = new HashMap<String, Schema>();
        Schema compiledSchema = SchemaCompiler.getInstance().compile(xmlSchema);
        compiledSchemaMap.put("scheme-xml", compiledSchema);
        Mockito.when((Object)api.getCompiledSchemas()).thenReturn(compiledSchemaMap);
        HashMap<String, String> schemaMap = new HashMap<String, String>();
        schemaMap.put("scheme-xml", xmlSchema);
        Mockito.when((Object)api.getConsolidatedSchemas()).thenReturn(schemaMap);
        HashMap<String, MimeType> body = new HashMap<String, MimeType>();
        MimeType mimeType = (MimeType)Mockito.mock(MimeType.class);
        Mockito.when((Object)mimeType.getType()).thenReturn((Object)"application/xml");
        Mockito.when((Object)mimeType.getSchema()).thenReturn((Object)"scheme-xml");
        body.put("application/xml", mimeType);
        Action mockedAction = (Action)Mockito.mock(Action.class);
        Mockito.when((Object)mockedAction.getBody()).thenReturn(body);
        Resource mockedResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockedResource.getAction("POST")).thenReturn((Object)mockedAction);
        Mockito.when((Object)api.getResource("/leagues")).thenReturn((Object)mockedResource);
    }

    @Test
    public void validStringPayloadUsingParser() throws TypedException, ExecutionException, BadRequestException {
        String payload = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><name>MLS</name></league>";
        String schemaPath = "/leagues,POST,application/xml";
        Configuration config = new Configuration();
        RamlHandler ramlHandler = (RamlHandler)Mockito.mock(RamlHandler.class);
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        Mockito.when((Object)ramlHandler.getApi()).thenReturn((Object)api);
        config.setRamlHandler(ramlHandler);
        RestXmlSchemaValidator xmlValidator = new RestXmlSchemaValidator(config.getXmlSchema(schemaPath), errorTypeRepository);
        xmlValidator.validate(payload);
    }

    @Test(expected=TypedException.class)
    public void invalidStringPayloadUsingParser() throws TypedException, BadRequestException, ExecutionException {
        String payload = "<league xmlns=\"http://mulesoft.com/schemas/soccer\"><invalid>hello</invalid></league>";
        String schemaPath = "/leagues,POST,application/xml";
        Configuration config = new Configuration();
        RamlHandler ramlHandler = (RamlHandler)Mockito.mock(RamlHandler.class);
        Mockito.when((Object)ramlHandler.getApi()).thenReturn((Object)api);
        config.setRamlHandler(ramlHandler);
        RestXmlSchemaValidator xmlValidator = new RestXmlSchemaValidator(config.getXmlSchema(schemaPath));
        xmlValidator.validate(payload);
    }

    @Test
    public void xxeAttackIsDisabled() throws TypedException, ExecutionException, BadRequestException {
        this.expectedException.expectMessage("An internal operation failed.");
        String payload = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE leagues [\n<!ENTITY mls \"MLS\">]>\n<league xmlns=\"http://mulesoft.com/schemas/soccer\"><name>&mls;</name></league>";
        String schemaPath = "/leagues,POST,application/xml";
        Configuration config = new Configuration();
        RamlHandler ramlHandler = (RamlHandler)Mockito.mock(RamlHandler.class);
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        ErrorType type = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)errorTypeRepository.getErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of(type));
        Mockito.when((Object)ramlHandler.getApi()).thenReturn((Object)api);
        config.setRamlHandler(ramlHandler);
        RestXmlSchemaValidator xmlValidator = new RestXmlSchemaValidator(config.getXmlSchema(schemaPath), errorTypeRepository);
        xmlValidator.validate(payload);
    }
}

