/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.apikit.model.Response;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;

public class AttributesHelper {
    private static final String ANY_RESPONSE_MEDIA_TYPE = "*/*";
    private static final String COMMA_SEPARATOR = ",";

    private AttributesHelper() {
    }

    public static MultiMap<String, String> copyImmutableMap(MultiMap<String, String> immutableMap) {
        MultiMap mapParam = new MultiMap();
        immutableMap.keySet().forEach(mapKey -> mapParam.put(mapKey, (Collection)immutableMap.getAll(mapKey)));
        return mapParam;
    }

    public static MultiMap<String, String> copyImmutableMap(MultiMap<String, String> immutableMap, String key, String value) {
        MultiMap<String, String> mapParam = AttributesHelper.copyImmutableMap(immutableMap);
        mapParam.put((Object)key, (Object)value);
        return mapParam;
    }

    public static String addQueryString(String oldQueryString, String key, String value) {
        String newParam = oldQueryString.length() != 0 ? "&" : "";
        try {
            newParam = newParam + URLEncoder.encode(key, "UTF-8");
            if (value != null) {
                newParam = newParam + "=" + URLEncoder.encode(value, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return oldQueryString + newParam;
    }

    public static HttpRequestAttributes replaceParams(HttpRequestAttributes attributes, MultiMap<String, String> headers, MultiMap<String, String> queryParams, String queryString, Map<String, String> uriParams) {
        return new HttpRequestAttributesBuilder(attributes).headers(headers).queryParams(queryParams).queryString(queryString).uriParams(uriParams).build();
    }

    public static String getParamValue(MultiMap<String, String> parameters, String parameterName) throws BadRequestException {
        List<String> paramValues = AttributesHelper.getParamValues(parameters, parameterName);
        int listSize = paramValues.size();
        if (listSize == 0) {
            return null;
        }
        if (listSize > 1 || paramValues.get(0).contains(COMMA_SEPARATOR)) {
            throw new BadRequestException("Multiple values are not allowed for \"" + parameterName + "\" header param");
        }
        return paramValues.get(0);
    }

    public static List<String> getParamValues(MultiMap<String, String> parameters, String parameterName) {
        return parameters.keySet().stream().filter(header -> header.equalsIgnoreCase(parameterName)).findFirst().map(arg_0 -> parameters.getAll(arg_0)).orElse(Collections.emptyList());
    }

    public static String getCommaSeparatedParamValues(MultiMap<String, String> parameters, String parameterName) {
        List<String> valuesList = AttributesHelper.getParamValues(parameters, parameterName);
        return valuesList.isEmpty() ? null : valuesList.stream().collect(Collectors.joining(COMMA_SEPARATOR));
    }

    public static String getContentType(MultiMap<String, String> headers) throws UnsupportedMediaTypeException {
        String contentType;
        try {
            contentType = AttributesHelper.getParamValue(headers, HeaderName.CONTENT_TYPE.getName());
        }
        catch (BadRequestException e) {
            throw new UnsupportedMediaTypeException("Unsupported mediaType. " + e.getMessage());
        }
        return Strings.isNullOrEmpty((String)contentType) ? null : AttributesHelper.getMediaType(contentType);
    }

    public static String getMediaType(String mediaType) throws UnsupportedMediaTypeException {
        try {
            MediaType mType = MediaType.parse((String)mediaType);
            return String.format("%s/%s", mType.getPrimaryType(), mType.getSubType());
        }
        catch (Exception e) {
            String message = mediaType == null ? "MediaType is null" : e.getMessage();
            throw new UnsupportedMediaTypeException(message);
        }
    }

    public static String getAcceptedResponseMediaTypes(MultiMap<String, String> headers) {
        String acceptableResponseMediaTypes = AttributesHelper.getCommaSeparatedParamValues(headers, HeaderName.ACCEPT.getName());
        return Strings.isNullOrEmpty((String)acceptableResponseMediaTypes) ? ANY_RESPONSE_MEDIA_TYPE : acceptableResponseMediaTypes;
    }

    public static String getSuccessStatus(Map<String, Response> responses) {
        for (String status : responses.keySet()) {
            if ("default".equalsIgnoreCase(status)) {
                return "200";
            }
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return status;
        }
        return "200";
    }
}

