/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.runtime.core.api.MuleContext;

public class RoutingTableTestCase {
    private static RamlHandler ramlHandler;
    private static MuleContext muleContext;

    @BeforeClass
    public static void beforeAll() throws IOException {
        muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        ramlHandler = new RamlHandler("unit/routing-table-sample.raml", true, muleContext.getErrorTypeRepository());
    }

    @Test
    public void testResourceFlattenedTree() {
        RoutingTable routingTable = new RoutingTable(ramlHandler.getApi());
        Assert.assertThat((Object)routingTable.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new URIPattern[]{new URIPattern("/single-resource"), new URIPattern("/api"), new URIPattern("/api/sub-resource"), new URIPattern("/api/sub-resource-types")}));
    }

    @Test
    public void getResourceByPattern() {
        RoutingTable routingTable = new RoutingTable(ramlHandler.getApi());
        Assert.assertNotNull((Object)routingTable.getResource(new URIPattern("/single-resource")));
        Assert.assertNotNull((Object)routingTable.getResource(new URIPattern("/api/sub-resource")));
    }

    @Test
    public void getResourceByString() {
        RoutingTable routingTable = new RoutingTable(ramlHandler.getApi());
        Assert.assertNotNull((Object)routingTable.getResource("/single-resource"));
        Assert.assertNotNull((Object)routingTable.getResource("/api/sub-resource"));
    }
}

