/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.InputStream;
import javax.xml.validation.Schema;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.api.ApiReference;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.api.validation.ApiKitJsonSchema;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.validation.RestRequestValidator;
import org.mule.parser.service.ParserMode;
import org.mule.parser.service.ParserService;
import org.mule.runtime.core.api.el.ExpressionManager;

public class TestRestRequestValidator {
    private String relativePath;
    private ParserMode parser;
    private ApiReference apiReference;
    private String charset;
    private InputStream body;
    private HttpRequestAttributes httpRequestAttributes;
    private ValidationConfig validationConfig;

    public TestRestRequestValidator(String relativePath, ParserMode parser, ApiReference apiReference, String charset, InputStream body, HttpRequestAttributes httpRequestAttributes, ValidationConfig validationConfig) {
        this.relativePath = relativePath;
        this.parser = parser;
        this.apiReference = apiReference;
        this.charset = charset;
        this.body = body;
        this.httpRequestAttributes = httpRequestAttributes;
        this.validationConfig = validationConfig != null ? validationConfig : new ValidationConfig(){

            public boolean isParserV2() {
                return true;
            }

            public ApiKitJsonSchema getJsonSchema(String schemaPath) {
                return null;
            }

            public Schema getXmlSchema(String schemaPath) {
                return null;
            }

            public ExpressionManager getExpressionManager() {
                return null;
            }
        };
    }

    public ValidRequest validateRequest() throws MuleRestException {
        URIResolver uriResolver = new URIResolver(this.relativePath);
        RoutingTable routingTable = new RoutingTable(new ParserService().parse(this.apiReference, this.parser).get());
        URIPattern pattern = uriResolver.find(routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
        Resource resource = routingTable.getResource(pattern);
        RestRequestValidator requestValidator = new RestRequestValidator(this.validationConfig, resource, null);
        return requestValidator.validate((ResolvedVariables)uriResolver.resolve(pattern), this.httpRequestAttributes, this.charset, (Object)this.body);
    }
}

