/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.OptionalLong;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.module.apikit.validation.body.form.MultipartFormValidator;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class MultipartFormValidatorTest {
    public static final String BOUNDARY = "test";
    public static final String MULTIPART_BODY = "--test\r\nContent-Disposition: form-data; name=\"file\" filename=\"fileName\"\r\nContent-Transfer-Encoding: 8bit\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\nhello world\r\n--test\r\nCustom-Header: customValue; customAttribute=customAttrValue\r\nContent-Disposition: form-data; name=\"part1\"\r\nContent-Transfer-Encoding: 8bit\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\nhello world\r\n--test--\r\n";

    @Test
    public void validate() throws Exception {
        MultipartFormValidator multipartFormValidator = new MultipartFormValidator(Collections.emptyMap());
        TypedValue typedValue = this.getTypedValue();
        TypedValue validatedTypedValue = multipartFormValidator.validate(typedValue);
        InputStream validatedInputStream = StreamUtils.unwrapCursorStream((Object)TypedValue.unwrap((Object)validatedTypedValue));
        Assert.assertEquals((long)typedValue.getByteLength().getAsLong(), (long)validatedTypedValue.getByteLength().getAsLong());
        Assert.assertEquals((Object)MULTIPART_BODY, (Object)IOUtils.toString((InputStream)validatedInputStream));
    }

    private TypedValue getTypedValue() {
        DataType dataType = DataType.builder((DataType)DataType.INPUT_STREAM).mediaType(MediaType.parse((String)"multipart/form-data; boundary=\"test\"")).build();
        ByteArrayInputStream in = new ByteArrayInputStream(MULTIPART_BODY.getBytes());
        return new TypedValue((Object)new RewindableInputStream((InputStream)in), dataType, OptionalLong.of(in.available()));
    }
}

