/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.apikit.MockingUtils;
import org.mule.module.apikit.utils.MuleVersionUtils;
import org.mule.runtime.core.api.config.MuleManifest;

public class MuleVersionUtilsTest {
    @Test
    public void newerVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.3.0");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void newerSnapshotVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.3.0-SNAPSHOT");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void olderVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.1.0");
        Assert.assertFalse((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void olderSnapshotVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.1.0-SNAPSHOT");
        Assert.assertFalse((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void sameVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void snapshotVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0-SNAPSHOT");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void hotFixVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0-hf1");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void hotFixWithDateSuffixVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0-20200525");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void releaseCandidateVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0-rc1");
        Assert.assertTrue((boolean)MuleVersionUtils.isAtLeast((String)"4.2.0"));
    }

    @Test
    public void invalidVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0");
        Assert.assertFalse((boolean)MuleVersionUtils.isAtLeast((String)"a.b.3"));
    }

    @Test
    public void blankVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0");
        Assert.assertFalse((boolean)MuleVersionUtils.isAtLeast((String)" "));
    }

    @Test
    public void nullVersionIsAtLeastTest() throws Exception {
        this.setManifestImplementationVersion("4.2.0");
        Assert.assertFalse((boolean)MuleVersionUtils.isAtLeast(null));
    }

    private void setManifestImplementationVersion(String version) throws Exception {
        Manifest manifestMock = (Manifest)Mockito.mock(Manifest.class);
        Mockito.when((Object)manifestMock.getMainAttributes()).thenReturn(Mockito.mock(Attributes.class));
        Mockito.when((Object)manifestMock.getMainAttributes().getValue(new Attributes.Name("Implementation-Version"))).thenReturn((Object)version);
        MockingUtils.setAccessible(MuleManifest.class.getDeclaredField("manifest"), manifestMock);
    }
}

