/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.apikit.ApiType;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.ApiVendor;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.core.api.MuleContext;

public class RamlHandlerTestCase {
    private static MuleContext muleContext;

    @BeforeClass
    public static void beforeAll() {
        muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void apiVendorForRaml08() {
        String ramlLocation = "unit/raml-handler/simple08.raml";
        String apiServer = "unused";
        RamlHandler handler = this.createRamlHandler(ramlLocation, true);
        handler.setApiServer(apiServer);
        TestCase.assertTrue((boolean)handler.getApiVendor().equals((Object)ApiVendor.RAML_08));
    }

    @Test
    public void isParserV2TrueUsingRaml10() {
        String ramlLocation = "unit/raml-handler/simple10.raml";
        String apiServer = "unused";
        RamlHandler handler = this.createRamlHandler(ramlLocation);
        handler.setApiServer(apiServer);
        TestCase.assertTrue((boolean)handler.isParserV2());
        TestCase.assertTrue((boolean)handler.getApiVendor().equals((Object)ApiVendor.RAML_10));
    }

    @Test
    public void addLocalHostAsServerWhenIsNotDefined() {
        String ramlLocation = "unit/raml-handler/simple10.raml";
        boolean keepRamlBaseUri = false;
        RamlHandler handler = this.createRamlHandler(ramlLocation, keepRamlBaseUri);
        handler.setApiServer("localhost:8081/");
        String rootRaml = handler.getAMFModel();
        Assert.assertThat((Object)rootRaml, (Matcher)StringContains.containsString((String)"localhost:8081/"));
    }

    @Test
    public void getRamlV2KeepRamlBaseUriTrue() {
        String ramlLocation = "unit/raml-handler/simple10-with-example.raml";
        boolean keepRamlBaseUri = true;
        String apiServer = "http://www.newBaseUri.com";
        RamlHandler handler = this.createRamlHandler(ramlLocation, keepRamlBaseUri);
        handler.setApiServer(apiServer);
        String rootRaml = handler.getRamlV2("unit/raml-handler/?raml");
        TestCase.assertTrue((boolean)rootRaml.contains("RAML 1.0"));
        TestCase.assertTrue((!rootRaml.contains(apiServer) ? 1 : 0) != 0);
        TestCase.assertTrue((boolean)rootRaml.contains("baseUri: http://localhost/myapi"));
    }

    @Test
    public void getRamlV2KeepRamlBaseUriFalse() {
        String ramlLocation = "unit/raml-handler/simple10-with-example.raml";
        String apiServer = "http://pepe.com";
        RamlHandler handler = this.createRamlHandler(ramlLocation, false);
        handler.setApiServer(apiServer);
        String ramlV1 = handler.getRamlV1();
        TestCase.assertTrue((boolean)ramlV1.contains("baseUri: " + apiServer));
        String ramlV2 = handler.getRamlV2("unit/raml-handler/?raml");
        TestCase.assertTrue((boolean)ramlV2.contains("baseUri: " + apiServer));
        String ramlAmf = handler.getAMFModel();
        Assert.assertThat((Object)ramlAmf, (Matcher)StringContains.containsString((String)("\"" + apiServer + "\"")));
    }

    @Test
    public void getRamlV2Example() {
        String ramlLocation = "unit/raml-handler/simple10-with-example.raml";
        String apiServer = "unused";
        RamlHandler handler = this.createRamlHandler(ramlLocation);
        handler.setApiServer(apiServer);
        TestCase.assertTrue((boolean)handler.getRamlV2("unit/raml-handler/example.json/?raml").contains("{\"name\":\"jane\"}"));
    }

    @Test
    public void testInitializationUsingAUTO() {
        boolean keepRamlBaseUri = true;
        RamlHandler handler = this.createRamlHandler("unit/raml-handler/amf-only.raml", true, ParserMode.AUTO);
        Assert.assertEquals((Object)ApiType.AMF, (Object)handler.getApi().getType());
        this.assertException("Invalid reference 'SomeTypo'", () -> this.createRamlHandler("unit/raml-handler/failing-api.raml", true, ParserMode.AUTO));
    }

    @Test
    public void testInitializationUsingAMF() {
        boolean keepRamlBaseUri = true;
        RamlHandler handler = this.createRamlHandler("unit/raml-handler/amf-only.raml", true, ParserMode.AMF);
        Assert.assertEquals((Object)ApiType.AMF, (Object)handler.getApi().getType());
        this.assertException("Unresolved reference 'SomeTypo'", () -> this.createRamlHandler("unit/raml-handler/failing-api.raml", true, ParserMode.AMF));
    }

    @Test
    public void testInitializationUsingRAML() {
        boolean keepRamlBaseUri = true;
        RamlHandler handler = this.createRamlHandler("unit/raml-handler/raml-parser-only.raml", true, ParserMode.RAML);
        Assert.assertEquals((Object)ApiType.RAML, (Object)handler.getApi().getType());
        this.assertException("Invalid reference 'SomeTypo'", () -> this.createRamlHandler("unit/raml-handler/failing-api.raml", true, ParserMode.RAML));
    }

    @Test
    public void ramlWithSpacesInPath() {
        RamlHandler handler = this.createRamlHandler("unit/space in path api/api.raml", true, ParserMode.RAML);
        ApiSpecification api = handler.getApi();
        Assert.assertEquals((Object)ApiType.RAML, (Object)api.getType());
        List refs = api.getAllReferences();
        TestCase.assertTrue((boolean)refs.stream().anyMatch(ref -> ref.endsWith("unit/space%20in%20path%20api/example.json")));
        TestCase.assertTrue((boolean)refs.stream().anyMatch(ref -> ref.endsWith("unit/space%20in%20path%20api/more%20spaces/schema.json")));
    }

    private <A extends Exception, B> void assertException(String message, Supplier<B> supplier) {
        try {
            supplier.get();
            TestCase.fail((String)"an exception was expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)message));
        }
    }

    private RamlHandler createRamlHandler(String ramlPath) {
        return this.createRamlHandler(ramlPath, true, ParserMode.AUTO);
    }

    private RamlHandler createRamlHandler(String ramlPath, boolean keepRamlBaseUri) {
        return this.createRamlHandler(ramlPath, keepRamlBaseUri, ParserMode.AUTO);
    }

    private RamlHandler createRamlHandler(String ramlPath, boolean keepRamlBaseUri, ParserMode parser) {
        try {
            return new RamlHandler(null, ramlPath, keepRamlBaseUri, muleContext.getErrorTypeRepository(), parser);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating RamlHandler", e);
        }
    }
}

