/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.apikit.model.api.ApiReference;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.validation.TestRestRequestValidator;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.util.MultiMap;

@RunWith(value=Parameterized.class)
public abstract class AbstractRequestValidatorTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected TestRestRequestValidatorBuilder testRestRequestValidatorBuilder;
    @Parameterized.Parameter(value=0)
    public ParserMode parser;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({ParserMode.AMF}, {ParserMode.RAML});
    }

    @Before
    public void setup() {
        this.testRestRequestValidatorBuilder = new TestRestRequestValidatorBuilder();
    }

    protected class TestRestRequestValidatorBuilder {
        private HttpRequestAttributesBuilder httpRequestAttributesBuilder = new HttpRequestAttributesBuilder().listenerPath("/api/*").version("1").scheme("http").requestUri("/").rawRequestUri("/").localAddress("").queryString("").remoteAddress("");
        private String apiLocation;
        private String method;
        private String relativePath;
        private String requestPath;
        private String rawRequestPath;
        private String charset;
        private InputStream body;
        private ValidationConfig validationConfig;

        public TestRestRequestValidatorBuilder withRelativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public TestRestRequestValidatorBuilder withRequestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public TestRestRequestValidatorBuilder withRawRequestPath(String rawRequestPath) {
            this.rawRequestPath = rawRequestPath;
            return this;
        }

        public TestRestRequestValidatorBuilder withMethod(String method) {
            this.method = method;
            return this;
        }

        public TestRestRequestValidatorBuilder withQueryParams(MultiMap<String, String> queryParams) {
            this.httpRequestAttributesBuilder.queryParams(queryParams);
            return this;
        }

        public TestRestRequestValidatorBuilder withUriParams(MultiMap<String, String> uriParams) {
            this.httpRequestAttributesBuilder.uriParams(uriParams);
            return this;
        }

        public TestRestRequestValidatorBuilder withListenerPath(String listenerPath) {
            this.httpRequestAttributesBuilder.listenerPath(listenerPath);
            return this;
        }

        public TestRestRequestValidatorBuilder withHeaders(MultiMap<String, String> headers) {
            this.httpRequestAttributesBuilder.headers(headers);
            return this;
        }

        public TestRestRequestValidatorBuilder withApiLocation(String apiLocation) {
            this.apiLocation = apiLocation;
            return this;
        }

        public TestRestRequestValidatorBuilder withValidationConfig(ValidationConfig validationConfig) {
            this.validationConfig = validationConfig;
            return this;
        }

        public TestRestRequestValidatorBuilder withBody(InputStream body) {
            this.body = body;
            return this;
        }

        public TestRestRequestValidatorBuilder withCharset(String payloadCharset) {
            this.charset = payloadCharset;
            return this;
        }

        public TestRestRequestValidator build() {
            this.validateMandatory();
            HttpRequestAttributes httpRequestAttributes = this.httpRequestAttributesBuilder.method(this.method).relativePath(this.relativePath).requestPath(this.requestPath).rawRequestPath(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.rawRequestPath}) ? this.rawRequestPath : this.relativePath).build();
            return new TestRestRequestValidator(this.relativePath, AbstractRequestValidatorTestCase.this.parser, ApiReference.create((String)this.apiLocation), this.charset, this.body, httpRequestAttributes, this.validationConfig);
        }

        private void validateMandatory() {
            Assert.assertNotNull((String)"API location is mandatory for the test to run", (Object)this.apiLocation);
            Assert.assertNotNull((String)"Request path is mandatory for the test to run", (Object)this.requestPath);
            Assert.assertNotNull((String)"Relative path is mandatory for the test to run", (Object)this.relativePath);
            Assert.assertNotNull((String)"Method is mandatory for the test to run", (Object)this.method);
        }
    }
}

