/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.runtime.api.util.MultiMap;

public class HeaderParamsRequestValidator
extends AbstractRequestValidatorTestCase {
    private void validateRequestForAcceptHeader(String acceptHeaderValue) throws MuleRestException {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Content-Type", (Object)"application/json");
        headers.put((Object)"Accept", (Object)acceptHeaderValue);
        this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/mime-types-api.raml").withRequestPath("/api/testMimeTypes").withRelativePath("/testMimeTypes").withMethod("POST").withHeaders((MultiMap<String, String>)headers).withBody((InputStream)PayloadHelper.makePayloadRepeatable((Object)IOUtils.toInputStream((String)"{\"message\":\"All Ok\"}", (Charset)Charset.defaultCharset()))).build().validateRequest();
    }

    @Test
    public void nullSubTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("application/");
    }

    @Test
    public void nullSubTypeWoSlashThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("application");
    }

    @Test
    public void nullTypeAndSubTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("/");
    }

    @Test
    public void nullTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("/json");
    }

    @Test
    public void invalidTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("application/xml");
    }

    @Test
    public void successWithValidAcceptHeaderValue() throws MuleRestException {
        this.validateRequestForAcceptHeader("application/json");
    }
}

