/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.validation;

import org.mule.apikit.model.Action;
import org.mule.apikit.model.Resource;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.MethodNotAllowedException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.validation.RestRequestValidator;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class RequestValidator {
    private RequestValidator() {
    }

    public static ValidRequest validate(ValidationConfig config, Resource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables, Object payload, ErrorTypeRepository errorTypeRepository) throws MuleRestException {
        return RequestValidator.validate(config, resource, attributes, resolvedVariables, payload, null, errorTypeRepository);
    }

    public static ValidRequest validate(ValidationConfig config, Resource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables, Object payload, String charset, ErrorTypeRepository errorTypeRepository) throws MuleRestException {
        if (resource == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unexpected error. Resource cannot be null"));
        }
        String method = attributes.getMethod().toLowerCase();
        Action action = resource.getAction(method);
        if (action == null) {
            throw new MethodNotAllowedException(resource.getResolvedUri((String)resolvedVariables.get("version")) + " : " + method);
        }
        return new RestRequestValidator(config, action, errorTypeRepository).validate(resolvedVariables, attributes, charset, payload);
    }
}

