/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.metadata;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.UnionShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.metadata.MetadataFactory;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

public class MessageListenerOutputTypeResolver
implements OutputTypeResolver<String>,
AttributesTypeResolver<String> {
    public String getCategoryName() {
        return "MessageListenerResolver";
    }

    public String getResolverName() {
        return "MessageListenerOutputTypeResolver";
    }

    public MetadataType getOutputType(MetadataContext metadataContext, String channelName) throws MetadataResolvingException {
        AsyncConfig config = (AsyncConfig)metadataContext.getConfig().get();
        MetadataFactory.exitIfNotReady(config);
        Optional<Operation> operation = AsyncApiUtils.getConsumerOperation(config.getApi(), channelName);
        if (!operation.isPresent()) {
            throw new MetadataResolvingException(I18nMessageFactory.createStaticMessage((String)"No operation found for channel {}", (Object[])new Object[]{channelName}).getMessage(), FailureCode.INVALID_METADATA_KEY);
        }
        List shapes = operation.get().requests().stream().flatMap(r -> r.payloads().stream()).map(p -> p.schema()).collect(Collectors.toList());
        List<String> schemaTypes = operation.get().requests().stream().flatMap(r -> r.payloads().stream()).map(p -> p.mediaType().value()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Shape shape = shapes.size() > 1 ? new UnionShape().withAnyOf(shapes) : (Shape)shapes.get(0);
        return new MetadataFactory(metadataContext).getMetadataType(shape, schemaTypes);
    }

    public MetadataType getAttributesType(MetadataContext metadataContext, String channelName) throws MetadataResolvingException {
        AsyncConfig config = (AsyncConfig)metadataContext.getConfig().get();
        MetadataFactory.exitIfNotReady(config);
        EndPoint endPoint = config.getApi().endPoints().stream().filter(ep -> ep.path().is((Object)channelName)).findFirst().get();
        List servers = endPoint.servers().isEmpty() ? config.getApi().servers() : endPoint.servers();
        TreeMap fields = new TreeMap();
        HashMap annotations = new HashMap();
        Set attributes = servers.stream().map(s -> ProtocolHandler.messageAttributesByProtocol(ProtocolHandler.protocolByName(s.protocol().value()))).collect(Collectors.toSet());
        Set objectTypes = attributes.stream().map(attr -> MessageListenerOutputTypeResolver.getMessageAttributes(metadataContext, attr, fields, annotations)).collect(Collectors.toSet());
        ObjectType objectType = objectTypes.size() > 1 ? metadataContext.getTypeBuilder().objectType().build() : (ObjectType)objectTypes.iterator().next();
        MetadataType restrictionType = objectType.getOpenRestriction().orElse(null);
        return new DefaultObjectType(fields.values(), true, restrictionType, MetadataFormat.JAVA, annotations);
    }

    private static ObjectType getMessageAttributes(MetadataContext metadataContext, Class<?> msgAttributes, Map<String, ObjectFieldType> fields, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        ObjectType objectType = (ObjectType)metadataContext.getTypeLoader().load(msgAttributes);
        objectType.getAnnotations().forEach(annotation -> annotations.put((Class<? extends TypeAnnotation>)annotation.getClass(), (TypeAnnotation)annotation));
        objectType.getFields().forEach(f -> fields.put(f.getKey().getName().toString(), (ObjectFieldType)f));
        return objectType;
    }
}

