/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.metadata;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataFactory.class);
    static final String AVRO_SCHEMA_PREFIX = "AvroSchema";
    static final String AVRO_SCHEMA_EXTENSION = ".avsc";
    static final String AVRO_SCHEMA_TYPE = "name";
    static final String MSG_TYPE = "MsgType";
    static MetadataFormat AVRO = new MetadataFormat("Avro", "avro", new String[]{"application/avro"});
    private final MetadataContext metadataContext;
    private final AsyncConfig config;
    private final ExpressionLanguageMetadataService metadataService;

    public MetadataFactory(MetadataContext metadataContext) {
        this.metadataContext = metadataContext;
        this.config = (AsyncConfig)metadataContext.getConfig().get();
        this.metadataService = this.config.getExpressionLanguageMetadataService();
    }

    public MetadataType getMetadataType(Shape shape, List<String> schemaTypes) throws MetadataResolvingException {
        return this.getMetadataType(this.metadataContext, shape, schemaTypes);
    }

    private MetadataType getMetadataType(MetadataContext metadataContext, Shape shape, List<String> schemaTypes) throws MetadataResolvingException {
        if (shape instanceof AnyShape && !schemaTypes.isEmpty()) {
            AnyShape anyShape = (AnyShape)shape;
            try {
                if (schemaTypes.isEmpty()) {
                    return this.getMetadataTypeForJson(anyShape);
                }
                String schemaType = schemaTypes.get(0);
                boolean avroSchema = anyShape.isAvroSchema();
                if (avroSchema && this.config.getMuleVersion().atLeast("4.8")) {
                    return this.getMetadataTypeForJson(anyShape);
                }
                if (schemaType.equals("application/json")) {
                    return this.getMetadataTypeForJson(anyShape);
                }
            }
            catch (IOException e) {
                throw new MetadataResolvingException("Failed to fetch MatadataType", FailureCode.UNKNOWN, (Throwable)e);
            }
        }
        return MetadataFactory.getDefaultMetadataType(metadataContext);
    }

    private MetadataType getMetadataTypeForJson(AnyShape anyShape) throws IOException {
        AMFConfiguration asyncApiAmfConfiguration = this.config.getAsyncApiAmfConfiguration();
        String jsonString = asyncApiAmfConfiguration.elementClient().buildJsonSchema(anyShape);
        JsonTypeLoader typeLoader = new JsonTypeLoader(jsonString);
        return typeLoader.load(null).orElse(MetadataFactory.getDefaultMetadataType(this.metadataContext));
    }

    /*
     * Exception decompiling
     */
    protected MetadataType getMetadataTypeForAvro(Shape shape) throws IOException, MetadataResolvingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File createSchemaFile(String name, String prefix, String extension) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        String schemaFilename = prefix + name + extension;
        File file = new File(tempDir, schemaFilename);
        file.createNewFile();
        return file;
    }

    @NotNull
    protected MetadataType getMetadataTypeForAvro(String dwScript, String typeName) {
        TypeLoader typeLoader = this.metadataService.createTypeLoader(dwScript, AVRO);
        return (MetadataType)typeLoader.load(typeName).get();
    }

    @NotNull
    private static String avroDwScript(String name, String schemaFile) {
        StringBuilder sb = new StringBuilder();
        sb.append("%dw 2.0").append(System.lineSeparator());
        sb.append("import " + name + " from avroschema!" + schemaFile).append(System.lineSeparator());
        sb.append("type MsgType = " + name);
        return sb.toString();
    }

    @NotNull
    private static String baseFileName(String schemaFilename) {
        return schemaFilename.substring(0, schemaFilename.lastIndexOf(46));
    }

    @Nullable
    private String getRecordTypeNameWithDw(String schema, String fieldName) {
        String dwExpr = "%dw 2.0\noutput application/java\n---\npayload." + fieldName;
        BindingContext context = BindingContext.builder().addBinding("payload", new TypedValue((Object)schema, DataType.JSON_STRING)).build();
        TypedValue exprValue = this.config.getExpressionManager().evaluate(dwExpr, context);
        return exprValue.getValue().toString();
    }

    @Nullable
    private String getAvroRecordTypeName(String schema) {
        return this.getRecordTypeNameWithDw(schema, AVRO_SCHEMA_TYPE);
    }

    public static MetadataType getDefaultMetadataType(MetadataContext metadataContext) {
        return metadataContext.getTypeBuilder().anyType().build();
    }

    static void exitIfNotReady(AsyncConfig config) throws MetadataResolvingException {
        if (!config.isInitialized().get()) {
            throw new MetadataResolvingException("API is not initialized yet", FailureCode.NONE);
        }
    }
}

