/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ApiResource {
    private final String group;
    private final String assetId;
    private final String version;
    public static final String OS_NAME = "os.name";
    public static final String OS_NAME_WINDOWS = "Windows";

    public ApiResource(String resource) {
        String[] elements = resource.split(":");
        this.group = elements[2];
        this.assetId = elements[3];
        this.version = elements[4];
    }

    private static String getLocalMavenRepository() {
        String userHome = System.getProperty("user.home");
        String mavenRepoDir = ".m2" + File.separator + "repository";
        return userHome + File.separator + mavenRepoDir;
    }

    public static String extractZipFile(String resourceUrl) throws IOException {
        File zipFile = new File(resourceUrl);
        if (!zipFile.exists()) {
            throw new FileNotFoundException("Zip file not found: " + resourceUrl);
        }
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));){
            File tempDir = Files.createTempDirectory("zip-extract", new FileAttribute[0]).toFile();
            ApiResource.extractEntries(zis, tempDir.getAbsolutePath());
            String absolutePath = tempDir.getAbsolutePath();
            if (System.getProperty(OS_NAME).contains(OS_NAME_WINDOWS)) {
                absolutePath = absolutePath.replace("\\", "/");
            }
            String string = absolutePath;
            return string;
        }
    }

    private static void extractEntries(ZipInputStream zis, String outputDir) throws IOException {
        ZipEntry entry;
        byte[] buffer = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            String filePath = outputDir + File.separator + entry.getName();
            if (entry.isDirectory()) {
                Files.createDirectories(Paths.get(filePath, new String[0]), new FileAttribute[0]);
                continue;
            }
            Files.createDirectories(Paths.get(filePath, new String[0]).getParent(), new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(filePath);
            Throwable throwable = null;
            try {
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fos == null) continue;
                if (throwable != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    public String getEventedApiPath() {
        return ApiResource.getLocalMavenRepository() + File.separator + this.group + File.separator + this.assetId + File.separator + this.version + File.separator + this.assetId + "-" + this.version + "-evented-api.zip";
    }

    public String getFatEventedApiPath() {
        return ApiResource.getLocalMavenRepository() + File.separator + this.group + File.separator + this.assetId + File.separator + this.version + File.separator + this.assetId + "-" + this.version + "-fat-evented-api.zip";
    }

    public boolean fatEventedApiExists() {
        return new File(this.getFatEventedApiPath()).exists();
    }

    public String getApiPath() {
        return this.fatEventedApiExists() ? this.getFatEventedApiPath() : this.getEventedApiPath();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }

    public static void deleteDirectory(String apidir) throws IOException {
        Path path = Paths.get(apidir, new String[0]);
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

