/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.parser;

import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.internal.ValidationResult;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.validation.AsyncOperation;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncApiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncApiUtils.class);

    public static Optional<Operation> getConsumerOperation(AsyncApi api, String specChannelName) {
        return AsyncApiUtils.getOperation(api, specChannelName, AsyncOperation.PUBLISH);
    }

    public static Optional<Operation> getProducerOperation(AsyncApi api, String specChannelName) {
        return AsyncApiUtils.getOperation(api, specChannelName, AsyncOperation.SUBSCRIBE);
    }

    private static Optional<Operation> getOperation(AsyncApi api, String specChannelName, AsyncOperation operation) {
        List operations = api.endPoints().stream().filter(e -> e.path().value().equals(specChannelName)).flatMap(e -> e.operations().stream()).filter(op -> op.method().value().equals(operation.label())).collect(Collectors.toList());
        if (operations.isEmpty()) {
            LOGGER.error("No '{}' channel found matching '{}'", (Object)operation, (Object)specChannelName);
            return Optional.empty();
        }
        if (operations.size() > 1) {
            LOGGER.warn("More than one '{}' channel found matching '{}', the first one will be used.", (Object)operation, (Object)specChannelName);
        }
        return Optional.of(operations.get(0));
    }

    public static String getMimeType(MediaType mediaType) {
        return mediaType.getPrimaryType() + "/" + mediaType.getSubType();
    }

    public static ProtocolHandler.Protocol getServerProtocol(AsyncApi asyncApi, String server) {
        String protocolName = asyncApi.servers().stream().filter(s -> server.equals(s.name().value())).findAny().orElseThrow(() -> new AsyncApiModuleException("No matching server found in api for server name {}", server)).protocol().value();
        return ProtocolHandler.protocolByName(protocolName);
    }

    public static MediaType getResolvedMediaType(AsyncApi api, Optional<MediaType> resultMediaType, String defaultEncoding) {
        Charset charSet = Charset.forName(AsyncApiUtils.getCharSet(resultMediaType, defaultEncoding));
        Predicate<MediaType> mediaTypeIsValid = m -> m.equals((Object)MediaType.APPLICATION_JSON.withCharset(charSet)) || m.equals((Object)MediaType.APPLICATION_XML.withCharset(charSet));
        if (resultMediaType.isPresent() && mediaTypeIsValid.test(resultMediaType.get())) {
            return resultMediaType.get();
        }
        if (api.contentType() != null && !api.contentType().isEmpty()) {
            return MediaType.parse((String)((StrField)api.contentType().get(0)).value());
        }
        return MediaType.APPLICATION_JSON;
    }

    public static String getCharSet(Optional<MediaType> mediaType, String defaultEncoding) {
        Optional<String> charSet = mediaType.flatMap(MediaType::getCharset);
        return charSet.map(Charset::name).orElse(defaultEncoding);
    }

    public static ValidationResult validate(InputStream input, AMFShapePayloadValidator validator) {
        try {
            if (input instanceof CursorStream) {
                return AsyncApiUtils.validateCursorStream((CursorStream)input, validator);
            }
            if (input instanceof ByteArrayInputStream) {
                return AsyncApiUtils.validateByteArrayInputStream(input, validator);
            }
            return ValidationResult.invalidStream();
        }
        catch (Exception e) {
            return ValidationResult.exceptionOnValidation(e);
        }
    }

    private static ValidationResult validateByteArrayInputStream(InputStream input, AMFShapePayloadValidator validator) throws IOException {
        ValidationResult validationResult = null;
        try {
            input.mark(Integer.MAX_VALUE);
            validationResult = AsyncApiUtils.validateContent(input, validator);
        }
        finally {
            input.reset();
        }
        return validationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValidationResult validateCursorStream(CursorStream input, AMFShapePayloadValidator validator) throws IOException {
        ValidationResult validationResult = null;
        long position = 0L;
        try {
            position = input.getPosition();
            validationResult = AsyncApiUtils.validateContent((InputStream)input, validator);
        }
        finally {
            input.seek(position);
        }
        return validationResult;
    }

    private static ValidationResult validateContent(InputStream input, AMFShapePayloadValidator validator) {
        String content = IOUtils.toString((InputStream)input);
        try {
            AMFValidationReport report = (AMFValidationReport)validator.validate(content).get();
            if (!report.conforms()) {
                return ValidationResult.failure(report.results().stream().map(AMFValidationResult::message).collect(Collectors.toList()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return ValidationResult.exceptionOnValidation(e);
        }
        return ValidationResult.success();
    }

    public static List<ValidationResult> validate(List<AMFShapePayloadValidator> validators, String channelName, String mimeType, InputStream input) {
        if (validators.isEmpty()) {
            LOGGER.debug("Validator not found for channel {}, mediaType {}", (Object)channelName, (Object)mimeType);
            return Collections.emptyList();
        }
        ValidationResult vresult = null;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (AMFShapePayloadValidator validator : validators) {
            ValidationResult result = AsyncApiUtils.validate(input, validator);
            if (result.isNonRepeatableStream() || result.isValid()) {
                vresult = result;
                break;
            }
            results.add(result);
        }
        if (vresult != null) {
            if (vresult.isNonRepeatableStream()) {
                LOGGER.info("Non repeatable stream received on channel {} with mediaType {}. Skipping validation", (Object)channelName, (Object)mimeType);
            }
            return Collections.emptyList();
        }
        return results;
    }
}

