/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.parser;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.ResourceLoader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class EventedZipFileResourceLoader
implements ResourceLoader {
    public CompletableFuture<Content> fetch(String resource) {
        CompletableFuture<Content> result = new CompletableFuture<Content>();
        try {
            if (resource == null) {
                result.completeExceptionally(new RuntimeException("Cannot resolve resource null"));
            }
            String fileContent = this.fileToString(resource);
            result.complete(new Content(fileContent, resource));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private String fileToString(String resource) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(resource));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        return content.toString();
    }
}

