/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols;

import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.kafka.KafkaProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.salesforcepubsub.SalesforcePubSubProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.solace.SolaceProtocolHandler;

public class ProtocolHandlerFactory {
    public ProtocolHandler<?, ?> buildProtocolHandler(ProtocolHandler.Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return new KafkaProtocolHandler();
            }
            case ANYPOINTMQ: {
                return new AnypointMQProtocolHandler();
            }
            case SOLACE: {
                return new SolaceProtocolHandler();
            }
            case SALESFORCEPUBSUB: {
                return new SalesforcePubSubProtocolHandler();
            }
        }
        throw new AsyncApiModuleException("Protocol '{}' not yet supported", protocol.name());
    }
}

