/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.amq;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import java.io.InputStream;
import java.util.List;
import org.mule.extension.async.apikit.api.attributes.AsyncMessageAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiRoutingException;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.protocols.MessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQMessageAttributesBuilder;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.runtime.extension.api.client.params.Parameterizer;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class AnypointMQMessageListenerHandler
extends MessageListenerHandler<InputStream, AnypointMQMessageAttributes> {
    protected String configRef;

    public AnypointMQMessageListenerHandler(AsyncApi api, SourceCallbackRegistry registry, AsyncConfig config, AMFElementClient amfElementClient, boolean disableValidation, String serverName, String channelName, String configRef, List<Binding> asyncBindings, String defaultEncoding) {
        super(api, registry, config, amfElementClient, disableValidation, serverName, channelName, asyncBindings, defaultEncoding);
        this.configRef = configRef;
    }

    @Override
    protected String getRuntimeChannelName(Result<InputStream, AnypointMQMessageAttributes> result) {
        return result.getAttributes().map(AnypointMQMessageAttributes::getDestination).orElseThrow(() -> new AsyncApiRoutingException("Unable to find destination name from AnypointMQ message"));
    }

    @Override
    public String getSourceListenerName() {
        return "subscriber";
    }

    @Override
    public void configureSourceListener(SourceParameterizer sourceParameterizer) {
        ((SourceParameterizer)sourceParameterizer.withConfigRef(this.configRef)).withParameter("destination", (Object)this.channelName);
        for (Binding asyncBinding : this.asyncBindings) {
            asyncBinding.applyBindings((Parameterizer)sourceParameterizer);
        }
    }

    @Override
    protected AsyncMessageAttributes buildResultAttributes(Result<InputStream, AnypointMQMessageAttributes> result, String specChannel) {
        AnypointMQMessageAttributes attributes = (AnypointMQMessageAttributes)result.getAttributes().orElseThrow(() -> new AsyncApiRoutingException("Unable to get attributes from AnypointMQ message"));
        return ((AnypointMQMessageAttributesBuilder)((AnypointMQMessageAttributesBuilder)((AnypointMQMessageAttributesBuilder)AnypointMQMessageAttributesBuilder.builder().channelName(attributes.getDestination())).serverName(this.serverName)).protocol(ProtocolHandler.Protocol.ANYPOINTMQ.name())).headers(attributes.getHeaders()).properties(attributes.getProperties()).messageId(attributes.getMessageId()).deliveryCount(attributes.getDeliveryCount()).contentType(attributes.getContentType()).ackToken(attributes.getAckToken()).build();
    }

    @Override
    protected InputStream buildResultOutput(Result<InputStream, AnypointMQMessageAttributes> result) {
        return (InputStream)result.getOutput();
    }
}

