/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.kafka;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.mule.extension.async.apikit.api.attributes.KafkaMessageAttributes;
import org.mule.extension.async.apikit.internal.protocols.AsyncMessageAttributesBuilder;
import org.mule.runtime.core.api.util.IOUtils;

public class KafkaMessageAttributesBuilder
extends AsyncMessageAttributesBuilder<KafkaMessageAttributes, KafkaMessageAttributesBuilder> {
    private int partition;
    private Map<String, String> headers;
    private String key;
    private long offset;
    private ZonedDateTime creationTimestamp;
    private ZonedDateTime logAppendTimestamp;
    private Integer leaderEpoch;

    private KafkaMessageAttributesBuilder() {
    }

    public static KafkaMessageAttributesBuilder builder() {
        return new KafkaMessageAttributesBuilder();
    }

    @Override
    protected KafkaMessageAttributesBuilder getThis() {
        return this;
    }

    public KafkaMessageAttributesBuilder partition(int partition) {
        this.partition = partition;
        return this;
    }

    public KafkaMessageAttributesBuilder headers(Map<String, byte[]> headers) {
        HashMap<String, String> mappedHeaders = new HashMap<String, String>();
        headers.forEach((key, value) -> mappedHeaders.put((String)key, IOUtils.toString((InputStream)new ByteArrayInputStream((byte[])value))));
        this.headers = mappedHeaders;
        return this;
    }

    public KafkaMessageAttributesBuilder key(InputStream key) {
        this.key = key != null ? IOUtils.toString((InputStream)key) : null;
        return this;
    }

    public KafkaMessageAttributesBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public KafkaMessageAttributesBuilder creationTimestamp(ZonedDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    public KafkaMessageAttributesBuilder logAppendTimestamp(ZonedDateTime logAppendTimestamp) {
        this.logAppendTimestamp = logAppendTimestamp;
        return this;
    }

    public KafkaMessageAttributesBuilder leaderEpoch(Integer leaderEpoch) {
        this.leaderEpoch = leaderEpoch;
        return this;
    }

    @Override
    public KafkaMessageAttributes build() {
        this.validateMandatoryFields();
        return new KafkaMessageAttributes(this.channelName, this.channelParameters, this.serverName, this.protocol, this.partition, this.headers, this.key, this.offset, this.creationTimestamp, this.logAppendTimestamp, this.leaderEpoch);
    }
}

