/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.salesforcepubsub;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import com.mulesoft.connector.salesforce.pubsub.api.EventDTO;
import com.mulesoft.connector.salesforce.pubsub.api.param.LatestReplayOption;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extension.async.apikit.api.attributes.AsyncMessageAttributes;
import org.mule.extension.async.apikit.api.attributes.SalesforcePubSubAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.protocols.MessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.extension.async.apikit.internal.protocols.salesforcepubsub.SalesforcePubSubMessageAttributesBuilder;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.extension.api.client.params.Parameterizer;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforcePubSubMessageListenerHandler
extends MessageListenerHandler<EventDTO, Void> {
    private static final Logger log = LoggerFactory.getLogger(SalesforcePubSubMessageListenerHandler.class);
    protected String configRef;
    private Map<String, CompiledExpression> compiledExpressionMap;

    public SalesforcePubSubMessageListenerHandler(AsyncApi api, SourceCallbackRegistry registry, AsyncConfig config, AMFElementClient amfElementClient, String serverName, boolean disableValidation, String channelName, String configRef, List<Binding> asyncBindings, String defaultEncoding) {
        super(api, registry, config, amfElementClient, disableValidation, serverName, channelName, asyncBindings, defaultEncoding);
        this.configRef = configRef;
        this.compiledExpressionMap = new ConcurrentHashMap<String, CompiledExpression>();
    }

    @Override
    public String getSourceListenerName() {
        return "subscribe-channel-listener";
    }

    @Override
    public void configureSourceListener(SourceParameterizer sourceParameterizer) {
        ((SourceParameterizer)((SourceParameterizer)sourceParameterizer.withConfigRef(this.configRef)).withParameter("channelName", (Object)this.channelName)).withParameter("replayOption", (Object)new LatestReplayOption());
        for (Binding asyncBinding : this.asyncBindings) {
            asyncBinding.applyBindings((Parameterizer)sourceParameterizer);
        }
    }

    @Override
    protected AsyncMessageAttributes buildResultAttributes(Result<EventDTO, Void> result, String specChannel) {
        SalesforcePubSubAttributes salesforcePubSubAttributes = ((SalesforcePubSubMessageAttributesBuilder)((SalesforcePubSubMessageAttributesBuilder)((SalesforcePubSubMessageAttributesBuilder)SalesforcePubSubMessageAttributesBuilder.builder().channelName(this.channelName)).serverName(this.serverName)).protocol(ProtocolHandler.Protocol.SALESFORCEPUBSUB.name())).build();
        return salesforcePubSubAttributes;
    }

    @Override
    protected InputStream buildResultOutput(Result<EventDTO, Void> result) {
        MediaType mediaType = AsyncApiUtils.getResolvedMediaType(this.api, result.getMediaType(), this.defaultEncoding);
        String mimeType = AsyncApiUtils.getMimeType(mediaType);
        String charSet = AsyncApiUtils.getCharSet(Optional.of(mediaType), this.defaultEncoding);
        BindingContext context = BindingContext.builder().addBinding("payload", new TypedValue(result.getOutput(), DataType.builder().mediaType((MediaType)result.getMediaType().get()).build())).build();
        TypedValue typedValue = null;
        CompiledExpression compiledExpression = this.getCompiledExpression(mimeType);
        try (ExpressionManagerSession session = this.asyncConfig.getExpressionManager().openSession(context);){
            typedValue = session.evaluate(compiledExpression);
        }
        try {
            byte[] bytes = ((String)typedValue.getValue()).getBytes(charSet);
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            log.error("Failure while creating result output for {}", (Object)ProtocolHandler.Protocol.SALESFORCEPUBSUB.name());
            throw new AsyncApiModuleException("Failure while creating result output", e);
        }
    }

    @Override
    protected String getRuntimeChannelName(Result<EventDTO, Void> result) {
        return this.channelName;
    }

    private CompiledExpression getCompiledExpression(String mimeType) {
        return this.compiledExpressionMap.computeIfAbsent(mimeType, key -> {
            String payload = mimeType.equals("application/xml") ? "root: payload" : "payload";
            String transformScript = "%dw 2.0\noutput application/java\n---\nwrite(" + payload + ", '" + mimeType + "')";
            return this.asyncConfig.getExpressionManager().compile(transformScript, BindingContextUtils.getTargetBindingContext((Message)Message.of((Object)"")));
        });
    }
}

