/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.solace;

import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.solace.SolaceConfig;
import org.mule.extension.async.apikit.internal.protocols.solace.SolaceMessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.solace.SolacePublishHandler;
import org.mule.runtime.api.util.Pair;

public class SolaceProtocolHandler
extends ProtocolHandler<SolaceMessageListenerHandler, SolacePublishHandler> {
    @Override
    public String getExtensionName() {
        return "Solace PubSub+ Connector";
    }

    @Override
    public void buildMessageListenerHandlersFor(AsyncConfig config, String server, String channelName, boolean disableValidation, String defaultEncoding) {
        SolaceConfig solaceConfig = config.getSolaceConfigs().stream().filter(c -> c.getServerKey().equals(server)).findFirst().orElseThrow(() -> new AsyncApiModuleException("No server found with key '{}'", server));
        Pair handlerKey = new Pair((Object)server, (Object)channelName);
        SolaceMessageListenerHandler messageListenerHandler = this.messageListenerHandlers.computeIfAbsent(handlerKey, key -> new SolaceMessageListenerHandler(config.getApi(), config.getSourceCallbackRegistry(), config, config.getAsyncApiAmfConfiguration().elementClient(), server, disableValidation, channelName, solaceConfig.getConfigRef(), config.getBindingsHandler().getSourceListenerAsyncBindings(channelName), defaultEncoding));
        this.sourceHandlers.putIfAbsent(handlerKey, config.getExtensionsClient().createSource(this.getExtensionName(), messageListenerHandler.getSourceListenerName(), messageListenerHandler::consumeSourceListenerResult, messageListenerHandler::configureSourceListener));
    }

    @Override
    public void buildPublishHandlersFor(AsyncConfig config, String server, String channelName) {
        SolaceConfig solaceConfig = (SolaceConfig)this.getServerConfig(config.getSolaceConfigs(), server);
        this.publishHandlers.putIfAbsent(new Pair((Object)server, (Object)channelName), new SolacePublishHandler(solaceConfig.getConfigRef()));
    }
}

