/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.solace;

import com.solace.connector.mulesoft.api.SolaceOutboundMessageType;
import com.solace.connector.mulesoft.api.param.OutboundAdditionalMessageProperties;
import com.solace.connector.mulesoft.api.param.SolaceMessageProperties;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.extension.async.apikit.api.PublishResponse;
import org.mule.extension.async.apikit.internal.operations.PublishParameters;
import org.mule.extension.async.apikit.internal.protocols.PublishHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.client.params.Parameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class SolacePublishHandler
implements PublishHandler<InputStream, SolaceMessageProperties> {
    private final String producerConfigRef;

    public SolacePublishHandler(String producerConfigRef) {
        this.producerConfigRef = producerConfigRef;
    }

    @Override
    public String getPublishOperationName() {
        return "Publish";
    }

    @Override
    public Consumer<OperationParameterizer> configurePublishOperationFor(PublishParameters parameters, TypedValue<InputStream> content, List<Binding> asyncBindings) {
        return operationParameterizer -> {
            ((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)operationParameterizer.withConfigRef(this.producerConfigRef)).withParameter("body", (Object)content)).withParameter("markAsReply", (Object)false)).withParameter("messageType", (Object)SolaceOutboundMessageType.DYNAMIC)).withParameter("address", (Object)parameters.getChannelName())).withParameter("additionalMessageProperties", (Object)new OutboundAdditionalMessageProperties());
            asyncBindings.forEach(asyncBinding -> asyncBinding.applyBindings((Parameterizer)operationParameterizer));
        };
    }

    @Override
    public Result<PublishResponse, Void> handleResult(Result<InputStream, SolaceMessageProperties> result) {
        HashMap<String, Object> outputMetadata = new HashMap<String, Object>();
        Optional attributes = result.getAttributes();
        attributes.ifPresent(attrs -> outputMetadata.put("applicationMessageId", attrs.getApplicationMessageId()));
        PublishResponse resultingOutput = new PublishResponse(outputMetadata);
        return Result.builder().output((Object)resultingOutput).build();
    }
}

