/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.sources;

import java.io.InputStream;
import java.util.Set;
import org.mule.extension.async.apikit.api.attributes.AsyncMessageAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.metadata.MessageListenerMetadataKeyResolver;
import org.mule.extension.async.apikit.internal.metadata.MessageListenerOutputTypeResolver;
import org.mule.extension.async.apikit.internal.protocols.MessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.sources.RoutingKey;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.client.source.SourceHandler;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@MediaType(value="*/*", strict=false)
@Alias(value="MessageListener")
@DisplayName(value="Message Listener")
@MetadataScope(keysResolver=MessageListenerMetadataKeyResolver.class, outputResolver=MessageListenerOutputTypeResolver.class, attributesResolver=MessageListenerOutputTypeResolver.class)
public class AsyncMessageListenerSource
extends Source<InputStream, AsyncMessageAttributes> {
    @Config
    private AsyncConfig config;
    @Parameter
    @Summary(value="Disable payload content validation")
    @ConfigOverride
    private boolean disableContentValidation;
    @Parameter
    @MetadataKeyId
    @Summary(value="Channel name")
    private String channelName;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of servers to listen to")
    private Set<String> servers;
    @DefaultEncoding
    private String defaultEncoding;
    private ComponentLocation location;

    public RoutingKey getKey() {
        return new RoutingKey(this.channelName);
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Set<String> getServers() {
        return this.servers;
    }

    public void onStart(SourceCallback<InputStream, AsyncMessageAttributes> sourceCallback) throws MuleException {
        this.config.getSourceCallbackRegistry().registerSourceCallback(this.getKey(), sourceCallback);
        for (String server : this.servers) {
            ProtocolHandler<?, ?> protocolHandler = this.config.getHandlerByServer(server);
            protocolHandler.buildMessageListenerHandlersFor(this.config, server, this.channelName, this.disableContentValidation, this.defaultEncoding);
            SourceHandler sourceHandler = protocolHandler.getSourceHandler(server, this.channelName);
            ((MessageListenerHandler)protocolHandler.getMessageListenerHandler(server, this.channelName)).setComponentLocation(this.location);
            sourceHandler.start();
        }
    }

    public void onStop() {
        for (String server : this.servers) {
            ProtocolHandler<?, ?> protocolHandler = this.config.getHandlerByServer(server);
            SourceHandler sourceHandler = protocolHandler.getSourceHandler(server, this.channelName);
            try {
                sourceHandler.stop();
            }
            catch (MuleException e) {
                throw new AsyncApiModuleException("An error occurred while stopping MessageListener source configuration for server {}", e, server);
            }
        }
        this.config.getSourceCallbackRegistry().unregisterSourceCallback(this.getKey());
    }

    @OnSuccess
    public void onSuccess(SourceCallbackContext callbackContext) {
        SourceResultHandler<?, ?> resultHandler = this.getCallbackContext(callbackContext);
        resultHandler.completeWithSuccess(p -> {});
    }

    @OnError
    public void onError(Error error, SourceCallbackContext callbackContext) {
        SourceResultHandler<?, ?> resultHandler = this.getCallbackContext(callbackContext);
        resultHandler.completeWithError(error.getCause(), p -> {});
    }

    private SourceResultHandler<?, ?> getCallbackContext(SourceCallbackContext callbackContext) {
        return (SourceResultHandler)callbackContext.getVariable("SourceResultHandlerKey").orElseThrow(() -> new IllegalStateException("Routing context not found"));
    }
}

