/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.validation;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.common.validation.ValidationMode;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.validation.AsyncOperation;
import org.mule.extension.async.apikit.internal.validation.ValidationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegistry.class);
    private final Map<ValidationKey, List<AMFShapePayloadValidator>> validators;
    private final AsyncConfig asyncConfig;

    public SchemaRegistry(AsyncConfig config) {
        this.asyncConfig = config;
        this.validators = new ConcurrentHashMap<ValidationKey, List<AMFShapePayloadValidator>>();
    }

    static Map<ValidationKey, List<AMFShapePayloadValidator>> registerMessages(AsyncApi api, String channel, AsyncOperation operation, String payloadMediaType, AMFElementClient elementClient) {
        Optional<EndPoint> endPoint = api.endPoints().stream().filter(e -> e.path().value().equals(channel)).findFirst();
        if (!endPoint.isPresent()) {
            LOGGER.warn("Could not find channel '{}'", (Object)channel);
            return Collections.emptyMap();
        }
        Optional<Operation> operationOptional = endPoint.get().operations().stream().filter(o -> o.method().is((Object)operation.label())).findFirst();
        if (!operationOptional.isPresent()) {
            LOGGER.warn("Could not find operation '{}' on channel '{}'", (Object)operation.label(), (Object)channel);
            return Collections.emptyMap();
        }
        Operation op = operationOptional.get();
        List messages = op.method().is((Object)AsyncOperation.PUBLISH.label()) ? op.requests() : op.responses();
        HashMap<ValidationKey, List<AMFShapePayloadValidator>> validatorMap = new HashMap<ValidationKey, List<AMFShapePayloadValidator>>();
        messages.forEach(r -> {
            Shape schema = ((Payload)r.payloads().get(0)).schema();
            String messageName = r.name().value();
            ValidationKey key = new ValidationKey(channel, operation, payloadMediaType);
            LOGGER.debug("Registering validator: key='{}', messageName={}, schema={}", new Object[]{key, messageName, schema});
            List list = validatorMap.getOrDefault(key, new ArrayList());
            AMFShapePayloadValidator validator = elementClient.payloadValidatorFor(schema, payloadMediaType, ValidationMode.StrictValidationMode());
            list.add(validator);
            validatorMap.put(key, list);
        });
        return validatorMap;
    }

    public List<AMFShapePayloadValidator> getValidators(AsyncApi api, String channel, AsyncOperation operation, String payloadMediaType, AMFElementClient elementClient) {
        List<AMFShapePayloadValidator> list;
        String[] supportedMediaTypes = new String[]{"application/json", "application/xml"};
        boolean registered = Arrays.stream(supportedMediaTypes).anyMatch(type -> this.validators.containsKey(new ValidationKey(channel, operation, (String)type)));
        if (!registered) {
            Map<ValidationKey, List<AMFShapePayloadValidator>> map = SchemaRegistry.registerMessages(api, channel, operation, payloadMediaType, elementClient);
            this.validators.putAll(map);
        }
        return (list = this.validators.get(new ValidationKey(channel, operation, payloadMediaType))) != null ? list : Collections.emptyList();
    }
}

