
package org.mule.modules.boxnet.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/boxnet</code>.
 * 
 */
public class BoxNetModuleNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new BoxNetModuleConfigDefinitionParser());
        registerBeanDefinitionParser("get-ticket", new GetTicketDefinitionParser());
        registerBeanDefinitionParser("auth-token", new AuthTokenDefinitionParser());
        registerBeanDefinitionParser("register-new-user", new RegisterNewUserDefinitionParser());
        registerBeanDefinitionParser("create-folder", new CreateFolderDefinitionParser());
        registerBeanDefinitionParser("upload-files", new UploadFilesDefinitionParser());
        registerBeanDefinitionParser("upload-stream", new UploadStreamDefinitionParser());
        registerBeanDefinitionParser("public-share", new PublicShareDefinitionParser());
        registerBeanDefinitionParser("public-unshare", new PublicUnshareDefinitionParser());
        registerBeanDefinitionParser("private-share", new PrivateShareDefinitionParser());
        registerBeanDefinitionParser("get-tree-structure", new GetTreeStructureDefinitionParser());
        registerBeanDefinitionParser("download", new DownloadDefinitionParser());
        registerBeanDefinitionParser("delete", new DeleteDefinitionParser());
        registerBeanDefinitionParser("logout", new LogoutDefinitionParser());
        registerBeanDefinitionParser("verify-registration-email", new VerifyRegistrationEmailDefinitionParser());
        registerBeanDefinitionParser("export-tags", new ExportTagsDefinitionParser());
        registerBeanDefinitionParser("move", new MoveDefinitionParser());
        registerBeanDefinitionParser("rename", new RenameDefinitionParser());
        registerBeanDefinitionParser("get-file-info", new GetFileInfoDefinitionParser());
        registerBeanDefinitionParser("add-to-tag", new AddToTagDefinitionParser());
        registerBeanDefinitionParser("set-description", new SetDescriptionDefinitionParser());
    }

}
