/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.clarizen;

import com.clarizen.api.AccessType;
import com.clarizen.api.EntityId;
import com.clarizen.api.GetCalendarInfoResult;
import com.clarizen.api.Recipient;
import com.clarizen.api.files.FileInformation;
import com.clarizen.api.metadata.EntityDescription;
import com.clarizen.api.queries.Condition;
import java.util.List;
import org.mule.api.ConnectionException;
import org.mule.modules.clarizen.api.ClarizenClient;
import org.mule.modules.clarizen.api.ClarizenClientFactory;
import org.mule.modules.clarizen.api.model.AllIssueType;
import org.mule.modules.clarizen.api.model.BaseClarizenEntity;
import org.mule.modules.clarizen.api.model.Login;
import org.mule.modules.clarizen.api.model.WorkItemFilter;
import org.mule.modules.clarizen.api.model.WorkItemState;
import org.mule.modules.clarizen.api.model.WorkItemType;

public class ClarizenConnector {
    private String connectionUser;
    private String connectionPassword;
    private String partnerId;
    private String applicationId;
    private String sessionId;
    private ClarizenClient clarizenClient;

    public Login login(String username, String password, String applicationId, String partnerId) {
        return this.clarizenClient.login(username, password, applicationId, partnerId);
    }

    public void logout() {
        this.clarizenClient.logout();
    }

    public BaseClarizenEntity getWorkItemById(WorkItemType workItemType, String workItemId, List<String> fieldsToRetrieve) {
        return this.clarizenClient.getWorkItemById(workItemType, workItemId, fieldsToRetrieve, true);
    }

    public BaseClarizenEntity createEntity(BaseClarizenEntity entity) {
        return this.clarizenClient.createEntity(entity);
    }

    public BaseClarizenEntity updateEntity(BaseClarizenEntity entity) {
        return this.clarizenClient.updateEntity(entity);
    }

    public List<BaseClarizenEntity> workItemsQuery(List<String> fieldsToRetrieve, WorkItemState workItemState, WorkItemType workItemType, WorkItemFilter workItemFilter, Integer pageSize, Integer maxNumberOfPages) {
        return this.clarizenClient.workItemsQuery(fieldsToRetrieve, workItemState, workItemType, workItemFilter, pageSize, maxNumberOfPages, true);
    }

    public List<BaseClarizenEntity> entityQuery(List<String> fieldsToRetrieve, String queryTypeName, Condition condition, Integer pageSize, Integer maxNumberOfPages) {
        return this.clarizenClient.createEntityQuery(fieldsToRetrieve, queryTypeName, condition, pageSize, maxNumberOfPages, true);
    }

    public List<BaseClarizenEntity> issueQuery(List<String> fieldsToRetrieve, AllIssueType issueType, Condition condition, Integer pageSize, Integer maxNumberOfPages) {
        return this.clarizenClient.createIssuesQuery(fieldsToRetrieve, issueType, condition, pageSize, maxNumberOfPages, true);
    }

    public List<BaseClarizenEntity> getMyWorkItems(List<String> fieldsToRetrieve, WorkItemState workItemState, WorkItemType workItemType, WorkItemFilter workItemFilter, Integer pageSize, Integer maxNumberOfPages) {
        return this.clarizenClient.getMyWorkItems(fieldsToRetrieve, workItemState, workItemType, workItemFilter, pageSize, maxNumberOfPages, true);
    }

    public List<EntityDescription> describeEntities(List<String> typeNames) {
        return this.clarizenClient.describeEntities(typeNames);
    }

    public List<String> listEntities() {
        return this.clarizenClient.listEntities();
    }

    public Boolean lifecycleChange(List<EntityId> entityIdList, String operation, Boolean recursive) {
        return this.clarizenClient.lifecycleChange(entityIdList, operation, recursive);
    }

    public Boolean deleteEntity(BaseClarizenEntity entity) {
        return this.clarizenClient.deleteEntity(entity);
    }

    public GetCalendarInfoResult getCalendarInformation(EntityId userId) {
        return this.clarizenClient.getCalendarInfo(userId);
    }

    public List<Object> getSystemSettings(List<String> settings) {
        return this.clarizenClient.getSystemSettings(settings);
    }

    public BaseClarizenEntity createFromTemplate(String templateName, BaseClarizenEntity entity) {
        return this.clarizenClient.createFromTemplate(templateName, entity);
    }

    public FileInformation downloadFileInformation(BaseClarizenEntity entity) {
        return this.clarizenClient.downloadFileInformation(entity);
    }

    public Boolean sendEmail(AccessType accessType, BaseClarizenEntity relatedEntity, String body, String subject, List<Recipient> recipients) {
        return this.clarizenClient.sendEmail(accessType, body, subject, recipients, relatedEntity);
    }

    public ClarizenClient getClarizenClient() {
        return this.clarizenClient;
    }

    public void setClarizenClient(ClarizenClient clarizenClient) {
        this.clarizenClient = clarizenClient;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public void setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void connect(String connectionUser, String connectionPassword, String applicationId, String partnerId) throws ConnectionException {
        this.connectionUser = connectionUser;
        this.connectionPassword = connectionPassword;
        if (this.clarizenClient == null) {
            this.setClarizenClient(ClarizenClientFactory.getClient());
        }
        this.setSessionId(this.login(connectionUser, connectionPassword, applicationId, partnerId).getLoginResult().getSessionId());
    }

    public void disconnect() {
        if (this.sessionId != null) {
            this.clarizenClient = null;
            this.sessionId = null;
            this.logout();
        }
    }

    public boolean validateConnection() {
        return this.sessionId != null;
    }

    public String toString() {
        return "username='" + this.connectionUser + '\'' + '}';
    }
}

