/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.clarizen;

import com.clarizen.api.AccessType;
import com.clarizen.api.ArrayOfBaseMessage;
import com.clarizen.api.Clarizen;
import com.clarizen.api.CreateFromTemplateMessage;
import com.clarizen.api.CreateMessage;
import com.clarizen.api.CreateResult;
import com.clarizen.api.DeleteMessage;
import com.clarizen.api.EntityId;
import com.clarizen.api.FieldValue;
import com.clarizen.api.GenericEntity;
import com.clarizen.api.GetCalendarInfoMessage;
import com.clarizen.api.GetCalendarInfoResult;
import com.clarizen.api.IClarizen;
import com.clarizen.api.IClarizenExecuteSessionTimeoutFailureFaultFaultMessage;
import com.clarizen.api.IClarizenLoginLoginFailureFaultFaultMessage;
import com.clarizen.api.IClarizenMetadataSessionTimeoutFailureFaultFaultMessage;
import com.clarizen.api.IClarizenQuerySessionTimeoutFailureFaultFaultMessage;
import com.clarizen.api.LifecycleMessage;
import com.clarizen.api.LoginOptions;
import com.clarizen.api.LoginResult;
import com.clarizen.api.Recipient;
import com.clarizen.api.Result;
import com.clarizen.api.RetrieveMessage;
import com.clarizen.api.RetrieveResult;
import com.clarizen.api.SendEMailMessage;
import com.clarizen.api.SessionHeader;
import com.clarizen.api.StringList;
import com.clarizen.api.UpdateMessage;
import com.clarizen.api.files.DownloadMessage;
import com.clarizen.api.files.DownloadResult;
import com.clarizen.api.files.FileInformation;
import com.clarizen.api.metadata.DescribeEntitiesMessage;
import com.clarizen.api.metadata.DescribeEntitiesResult;
import com.clarizen.api.metadata.EntityDescription;
import com.clarizen.api.metadata.GetSystemSettingsValuesMessage;
import com.clarizen.api.metadata.GetSystemSettingsValuesResult;
import com.clarizen.api.metadata.ListEntitiesMessage;
import com.clarizen.api.metadata.ListEntitiesResult;
import com.clarizen.api.projectmanagement.MyWorkItemsQuery;
import com.clarizen.api.projectmanagement.WorkItemsQuery;
import com.clarizen.api.queries.Condition;
import com.clarizen.api.queries.EntityQuery;
import com.clarizen.api.queries.Paging;
import com.clarizen.api.queries.Query;
import com.clarizen.api.queries.QueryResult;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.mule.modules.clarizen.ClarizenRuntimeException;
import org.mule.modules.clarizen.ClarizenSessionTimeoutException;
import org.mule.modules.clarizen.api.ClarizenClient;
import org.mule.modules.clarizen.api.ClarizenClientHelper;
import org.mule.modules.clarizen.api.ClarizenDateConverter;
import org.mule.modules.clarizen.api.ClarizenServiceProvider;
import org.mule.modules.clarizen.api.model.AllIssueType;
import org.mule.modules.clarizen.api.model.BaseClarizenEntity;
import org.mule.modules.clarizen.api.model.Login;
import org.mule.modules.clarizen.api.model.WorkItemFilter;
import org.mule.modules.clarizen.api.model.WorkItemState;
import org.mule.modules.clarizen.api.model.WorkItemType;

public class DefaultClarizenClient
implements ClarizenClient {
    private ClarizenClientHelper helper = new ClarizenClientHelper();
    private IClarizen service;
    private ClarizenServiceProvider serviceProvider;
    private String sessionId;
    private ConvertUtilsBean convertUtilsBean;
    private ClarizenDateConverter clarizenDateConverter;
    private BeanUtilsBean beanUtilsBean;
    private static final String DEFAULT_DATE_CONVERTER_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DEFAULT_PACKAGE_MODEL = "org.mule.modules.clarizen.api.model.";
    private static final String DEFAULT_PACKAGE_MODEL_FLAT = "org.mule.modules.clarizen.api.model.flat.";
    private static final String SUFFIX_FLAT_CLASSES = "Flat";

    public DefaultClarizenClient(ClarizenServiceProvider provider) {
        this.serviceProvider = provider;
        this.convertUtilsBean = new ConvertUtilsBean();
        this.clarizenDateConverter = new ClarizenDateConverter();
        this.clarizenDateConverter.setPattern(DEFAULT_DATE_CONVERTER_PATTERN);
        this.convertUtilsBean.register((Converter)this.clarizenDateConverter, Date.class);
        this.beanUtilsBean = new BeanUtilsBean(this.convertUtilsBean, new PropertyUtilsBean());
    }

    @Override
    public <T extends BaseClarizenEntity> List<T> createEntityQuery(List<String> fieldsToRetrieve, String queryTypeName, Condition condition, Integer pageSize, Integer maxNumberOfPages, boolean useFlatClasses) {
        EntityQuery query = new EntityQuery();
        query.setTypeName(queryTypeName);
        if (condition != null) {
            query.setWhere(condition);
        }
        List<GenericEntity> results = this.createQuery(query, fieldsToRetrieve, pageSize, maxNumberOfPages);
        return this.listBaseClarizenEntityFromGenericEntity(results, query.getTypeName(), useFlatClasses);
    }

    @Override
    public <T extends BaseClarizenEntity> List<T> createIssuesQuery(List<String> fieldsToRetrieve, AllIssueType issueType, Condition condition, Integer pageSize, Integer maxNumberOfPages, boolean useFlatClasses) {
        EntityQuery query = new EntityQuery();
        query.setTypeName(issueType.value());
        if (condition != null) {
            query.setWhere(condition);
        }
        List<GenericEntity> results = this.createQuery(query, fieldsToRetrieve, pageSize, maxNumberOfPages);
        return this.listBaseClarizenEntityFromGenericEntity(results, query.getTypeName(), useFlatClasses);
    }

    @Override
    public List<EntityDescription> describeEntities(List<String> typeNames) {
        DescribeEntitiesResult result;
        DescribeEntitiesMessage describeEntityMsg = new DescribeEntitiesMessage();
        StringList types = new StringList();
        types.getString().addAll(typeNames);
        describeEntityMsg.setTypeNames(types);
        try {
            result = (DescribeEntitiesResult)this.getService().metadata(describeEntityMsg);
            if (!result.isSuccess()) {
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenMetadataSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return result.getEntityDescriptions().getEntityDescription();
    }

    @Override
    public <T extends BaseClarizenEntity> List<T> getMyWorkItems(List<String> fieldsToRetrieve, WorkItemState workItemState, WorkItemType workItemType, WorkItemFilter workItemFilter, Integer pageSize, Integer maxNumberOfPages, Boolean useFlatClasses) {
        MyWorkItemsQuery query = new MyWorkItemsQuery();
        query.setItemsState(this.helper.createWorkItemState(workItemState.value()));
        query.setItemsFilter(this.helper.createWorkItemFilter(workItemFilter.value()));
        query.setItemsType(this.helper.createWorkItemType(workItemType.value()));
        List<GenericEntity> results = this.createQuery(query, fieldsToRetrieve, pageSize, maxNumberOfPages);
        String classToRetrieve = "WorkItem";
        if (workItemType != WorkItemType.ALL) {
            classToRetrieve = workItemType.value();
        }
        return this.listBaseClarizenEntityFromGenericEntity(results, classToRetrieve, useFlatClasses);
    }

    @Override
    public BaseClarizenEntity getWorkItemById(WorkItemType type, String workItemId, List<String> fieldsToRetrieve, boolean useFlatClasses) {
        RetrieveResult result;
        RetrieveMessage retrieveMsg = new RetrieveMessage();
        retrieveMsg.setId(this.helper.createBaseEntityId(type.value(), workItemId));
        StringList fields = new StringList();
        if (fieldsToRetrieve != null) {
            fields.getString().addAll(fieldsToRetrieve);
        }
        if (fields != null) {
            retrieveMsg.setFields(fields);
        }
        ArrayOfBaseMessage messages = this.helper.createMessage(retrieveMsg);
        try {
            result = (RetrieveResult)this.getService().execute(messages).getResult().get(0);
            if (!result.isSuccess()) {
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        BaseClarizenEntity baseClarizenEntity = this.createBaseClarizenEntity(type.value(), false);
        return this.toBaseClarizenEntity((GenericEntity)result.getEntity(), baseClarizenEntity, type.value(), useFlatClasses);
    }

    @Override
    public List<String> listEntities() {
        ListEntitiesResult result;
        ListEntitiesMessage listEntityMsg = new ListEntitiesMessage();
        try {
            result = (ListEntitiesResult)this.getService().metadata(listEntityMsg);
            if (!result.isSuccess()) {
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenMetadataSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return result.getTypeNames().getString();
    }

    @Override
    public Login login(String username, String password, String applicationId, String partnerId) {
        LoginResult login;
        LoginOptions opts = new LoginOptions();
        opts.setApplicationId(applicationId);
        opts.setPartnerId(partnerId);
        try {
            login = this.getService().login(username, password, opts);
        }
        catch (IClarizenLoginLoginFailureFaultFaultMessage e) {
            throw new ClarizenRuntimeException(e);
        }
        SessionHeader sessionHeader = new SessionHeader();
        sessionHeader.setID(login.getSessionId());
        this.setSessionId(login.getSessionId());
        try {
            ((BindingProvider)this.getService()).getRequestContext().put(Header.HEADER_LIST, Arrays.asList(new Header(new QName(Clarizen.SERVICE.getNamespaceURI(), "Session"), (Object)this.helper.createSessionHeader(this.getSessionId()), (DataBinding)new JAXBDataBinding(new Class[]{SessionHeader.class}))));
        }
        catch (JAXBException e1) {
            throw new RuntimeException(e1);
        }
        return new Login(login);
    }

    @Override
    public void logout() {
        this.getService().logout();
    }

    @Override
    public <T extends BaseClarizenEntity> List<T> workItemsQuery(List<String> fieldsToRetrieve, WorkItemState workItemState, WorkItemType workItemType, WorkItemFilter workItemFilter, Integer pageSize, Integer maxNumberOfPages, Boolean useFlatClasses) {
        WorkItemsQuery query = new WorkItemsQuery();
        query.setItemsState(this.helper.createWorkItemState(workItemState.value()));
        query.setItemsFilter(this.helper.createWorkItemFilter(workItemFilter.value()));
        query.setItemsType(this.helper.createWorkItemType(workItemType.value()));
        List<GenericEntity> results = this.createQuery(query, fieldsToRetrieve, pageSize, maxNumberOfPages);
        String classToRetrieve = "WorkItem";
        if (workItemType != WorkItemType.ALL) {
            classToRetrieve = workItemType.value();
        }
        return this.listBaseClarizenEntityFromGenericEntity(results, classToRetrieve, useFlatClasses);
    }

    private List<GenericEntity> createQuery(Query query, List<String> fieldsToRetrieve, Integer pageSize, Integer maxNumberOfPages) {
        int pageNumber = 0;
        ArrayList<GenericEntity> listResults = new ArrayList<GenericEntity>();
        if (pageSize > 1000 || pageSize < 100) {
            pageSize = 100;
        }
        StringList fields = new StringList();
        if (fieldsToRetrieve != null) {
            fields.getString().addAll(fieldsToRetrieve);
        }
        if (fields != null) {
            try {
                query.getClass().getMethod("setFields", StringList.class).invoke((Object)query, fields);
            }
            catch (IllegalArgumentException e) {
                throw new ClarizenRuntimeException(e);
            }
            catch (SecurityException e) {
                throw new ClarizenRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new ClarizenRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ClarizenRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ClarizenRuntimeException(e);
            }
        }
        query.setPaging(new Paging());
        try {
            QueryResult queryResult;
            do {
                query.getPaging().setPageNumber(pageNumber);
                query.getPaging().setPageSize(pageSize);
                queryResult = this.getService().query(query);
                if (!queryResult.isSuccess()) {
                    throw new ClarizenRuntimeException(queryResult.getError().getErrorCode(), queryResult.getError().getMessage());
                }
                listResults.addAll(queryResult.getEntities().getBaseEntity());
            } while (queryResult.getPaging().isHasMore().booleanValue() && ++pageNumber != maxNumberOfPages);
        }
        catch (IClarizenQuerySessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return listResults;
    }

    @Override
    public Boolean lifecycleChange(List<EntityId> entityIdList, String operation, Boolean recursive) {
        LifecycleMessage lifecycleMessage = new LifecycleMessage();
        lifecycleMessage.setIds(this.helper.createArrayOfEntityId(entityIdList));
        lifecycleMessage.setOperation(operation);
        lifecycleMessage.setRecursive(recursive);
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(lifecycleMessage);
        try {
            List<Result> results = this.getService().execute(messages).getResult();
            for (Result result : results) {
                if (result.isSuccess()) continue;
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return true;
    }

    @Override
    public BaseClarizenEntity createEntity(BaseClarizenEntity entity) {
        List<Result> results;
        GenericEntity genericEntity = this.toGenericEntity(entity);
        CreateMessage entityMessage = new CreateMessage();
        entityMessage.setEntity(genericEntity);
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(entityMessage);
        try {
            results = this.getService().execute(messages).getResult();
            for (CreateResult createResult : results) {
                if (createResult.isSuccess()) continue;
                throw new ClarizenRuntimeException(createResult.getError().getErrorCode(), createResult.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        if (((CreateResult)results.get(0)).getId() != null) {
            entity.setId(((CreateResult)results.get(0)).getId());
        }
        return entity;
    }

    @Override
    public BaseClarizenEntity updateEntity(BaseClarizenEntity entity) {
        GenericEntity genericEntity = this.toGenericEntity(entity);
        UpdateMessage updateMsg = new UpdateMessage();
        updateMsg.setEntity(genericEntity);
        ArrayOfBaseMessage messages = this.helper.createMessage(updateMsg);
        try {
            Result result = this.getService().execute(messages).getResult().get(0);
            if (!result.isSuccess()) {
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return entity;
    }

    @Override
    public Boolean deleteEntity(BaseClarizenEntity entity) {
        DeleteMessage deleteMsg = new DeleteMessage();
        deleteMsg.setId(entity.getId());
        ArrayOfBaseMessage messages = this.helper.createMessage(deleteMsg);
        try {
            Result result = this.getService().execute(messages).getResult().get(0);
            if (!result.isSuccess()) {
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return true;
    }

    private BaseClarizenEntity toBaseClarizenEntity(GenericEntity genericEntity, BaseClarizenEntity newEntity, String clarizenType, boolean useFlatClasses) {
        BaseClarizenEntity baseEntity = null;
        baseEntity = newEntity != null ? newEntity : this.createBaseClarizenEntity(clarizenType, useFlatClasses);
        try {
            EntityId entityId = (EntityId)genericEntity.getClass().getMethod("getId", new Class[0]).invoke((Object)genericEntity, new Object[0]);
            if (entityId == null) {
                baseEntity.setId(this.helper.createBaseEntityId(genericEntity.getClass().getSimpleName(), null));
            } else {
                baseEntity.setId(entityId);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClarizenRuntimeException(e);
        }
        List<FieldValue> entityFields = genericEntity.getValues().getFieldValue();
        Map<String, Object> entityFieldsMap = this.getFieldsFromGenericEntity(entityFields, useFlatClasses);
        try {
            this.beanUtilsBean.populate((Object)baseEntity, entityFieldsMap);
        }
        catch (IllegalAccessException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClarizenRuntimeException(e);
        }
        return baseEntity;
    }

    private BaseClarizenEntity createBaseClarizenEntity(String clarizenType, boolean useFlatClasses) {
        String clarizenClassName;
        if (useFlatClasses) {
            String defaultPackageModel = DEFAULT_PACKAGE_MODEL_FLAT;
            clarizenClassName = defaultPackageModel + StringUtils.capitalize((String)clarizenType) + SUFFIX_FLAT_CLASSES;
        } else {
            String defaultPackageModel = DEFAULT_PACKAGE_MODEL;
            clarizenClassName = defaultPackageModel + StringUtils.capitalize((String)clarizenType);
        }
        try {
            return (BaseClarizenEntity)Class.forName(clarizenClassName).newInstance();
        }
        catch (InstantiationException e1) {
            throw new ClarizenRuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new ClarizenRuntimeException(e1);
        }
        catch (ClassNotFoundException e1) {
            throw new ClarizenRuntimeException(e1);
        }
    }

    private Map<String, Object> getFieldsFromGenericEntity(List<FieldValue> entityFields, boolean useFlatClasses) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        ArrayList<FieldValue> customFields = new ArrayList<FieldValue>();
        for (FieldValue field : entityFields) {
            String fieldName = StringUtils.uncapitalize((String)field.getFieldName());
            if (field.getValue() == null) continue;
            Object fieldValue = field.getValue() instanceof GenericEntity ? this.toBaseClarizenEntity((GenericEntity)field.getValue(), null, ((GenericEntity)field.getValue()).getId().getTypeName(), useFlatClasses) : field.getValue();
            if (fieldName.startsWith("c_")) {
                customFields.add(field);
                continue;
            }
            entityMap.put(fieldName, fieldValue);
        }
        if (customFields != null && customFields.size() > 0) {
            entityMap.put("customFields", customFields);
        }
        return entityMap;
    }

    private GenericEntity toGenericEntity(Object entity) {
        GenericEntity newGenericEntity = new GenericEntity();
        if (this.isAnEntityId(entity.getClass(), null)) {
            newGenericEntity.setId((EntityId)entity);
            return newGenericEntity;
        }
        try {
            EntityId entityId = (EntityId)entity.getClass().getMethod("getId", new Class[0]).invoke(entity, new Object[0]);
            if (entityId == null) {
                newGenericEntity.setId(this.helper.createBaseEntityId(this.extractFlatName(entity.getClass().getSimpleName()), null));
            } else {
                newGenericEntity.setId(entityId);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClarizenRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClarizenRuntimeException(e);
        }
        List<FieldValue> entityFields = this.getFieldValuesFromBean(entity);
        if (entityFields != null) {
            newGenericEntity.setValues(this.helper.createGenericEntityArrayOfFieldValue(entityFields));
        }
        return newGenericEntity;
    }

    private List<FieldValue> getFieldValuesFromBean(Object entity) {
        ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
        BeanMap beanMap = new BeanMap(entity);
        for (String propertyName : beanMap.keySet()) {
            Object fieldValue = beanMap.get((Object)propertyName);
            if (fieldValue == null) continue;
            if (propertyName.equalsIgnoreCase("customFields")) {
                fields.addAll((List)fieldValue);
                continue;
            }
            if (this.isAttributeAnEntity(fieldValue.getClass()) || this.isAnEntityId(fieldValue.getClass(), propertyName)) {
                fieldValue = this.toGenericEntity(fieldValue);
            }
            if (propertyName.equalsIgnoreCase("class") || propertyName.equalsIgnoreCase("id")) continue;
            fields.add(this.helper.createFieldValue(propertyName, fieldValue));
        }
        return fields;
    }

    private boolean isAttributeAnEntity(Class<? extends Object> clazz) {
        return BaseClarizenEntity.class.isAssignableFrom(clazz);
    }

    private boolean isAnEntityId(Class<? extends Object> clazz, String entityName) {
        return EntityId.class.isAssignableFrom(clazz) && !StringUtils.equals((String)entityName, (String)"entityType") && !StringUtils.equals((String)entityName, (String)"id");
    }

    private String extractFlatName(String className) {
        return StringUtils.removeEnd((String)className, (String)SUFFIX_FLAT_CLASSES);
    }

    private List<BaseClarizenEntity> listBaseClarizenEntityFromGenericEntity(List<GenericEntity> listGenericEntity, String clarizenType, boolean useFlatClasses) {
        ArrayList<BaseClarizenEntity> list = new ArrayList<BaseClarizenEntity>();
        for (GenericEntity genericEntity : listGenericEntity) {
            BaseClarizenEntity newEntity = this.createBaseClarizenEntity(clarizenType, false);
            list.add(this.toBaseClarizenEntity(genericEntity, newEntity, clarizenType, useFlatClasses));
        }
        return list;
    }

    public ClarizenClientHelper getHelper() {
        return this.helper;
    }

    public void setHelper(ClarizenClientHelper helper) {
        this.helper = helper;
    }

    public void setService(IClarizen service) {
        this.service = service;
    }

    public void setServiceProvider(ClarizenServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    protected IClarizen getService() {
        if (this.service == null) {
            this.service = this.serviceProvider.getService();
        }
        return this.service;
    }

    public ClarizenServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public GetCalendarInfoResult getCalendarInfo(EntityId userId) {
        List<Result> results;
        GetCalendarInfoMessage getCalendarInfoMsg = new GetCalendarInfoMessage();
        getCalendarInfoMsg.setUserId(userId);
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(getCalendarInfoMsg);
        try {
            results = this.getService().execute(messages).getResult();
            for (Result result : results) {
                if (result.isSuccess()) continue;
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return (GetCalendarInfoResult)results.get(0);
    }

    @Override
    public List<Object> getSystemSettings(List<String> settingList) {
        GetSystemSettingsValuesMessage getSystemSettingsInfoMsg = new GetSystemSettingsValuesMessage();
        getSystemSettingsInfoMsg.setSettings(this.helper.createStringList(settingList));
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(getSystemSettingsInfoMsg);
        ArrayList<Object> listOfResults = new ArrayList<Object>();
        try {
            List<Result> results = this.getService().execute(messages).getResult();
            for (Result result : results) {
                if (!result.isSuccess()) {
                    throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
                }
                listOfResults.addAll(((GetSystemSettingsValuesResult)result).getValues().getAnyType());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return listOfResults;
    }

    @Override
    public BaseClarizenEntity createFromTemplate(String templateName, BaseClarizenEntity entity) {
        List<Result> results;
        CreateFromTemplateMessage createFromTemplateMsg = new CreateFromTemplateMessage();
        createFromTemplateMsg.setTemplateName(templateName);
        createFromTemplateMsg.setEntity(this.toGenericEntity(entity));
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(createFromTemplateMsg);
        try {
            results = this.getService().execute(messages).getResult();
            for (CreateResult createResult : results) {
                if (createResult.isSuccess()) continue;
                throw new ClarizenRuntimeException(createResult.getError().getErrorCode(), createResult.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        if (((CreateResult)results.get(0)).getId() != null) {
            entity.setId(((CreateResult)results.get(0)).getId());
        }
        return entity;
    }

    @Override
    public FileInformation downloadFileInformation(BaseClarizenEntity entity) {
        List<Result> results;
        DownloadMessage downloadMessage = new DownloadMessage();
        downloadMessage.setDocumentId(entity.getId());
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(downloadMessage);
        try {
            results = this.getService().execute(messages).getResult();
            for (DownloadResult downloadResult : results) {
                if (downloadResult.isSuccess()) continue;
                throw new ClarizenRuntimeException(downloadResult.getError().getErrorCode(), downloadResult.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return ((DownloadResult)results.get(0)).getFileInformation();
    }

    @Override
    public Boolean sendEmail(AccessType accessType, String body, String subject, List<Recipient> recipients, BaseClarizenEntity relatedEntity) {
        SendEMailMessage sendEmailMessage = new SendEMailMessage();
        sendEmailMessage.setAccessType(accessType);
        sendEmailMessage.setBody(body);
        sendEmailMessage.setSubject(subject);
        if (recipients != null) {
            sendEmailMessage.setRecipients(this.helper.createArrayOfRecipients(recipients));
        }
        if (relatedEntity != null) {
            sendEmailMessage.setRelatedEntity(relatedEntity.getId());
        }
        ArrayOfBaseMessage messages = new ArrayOfBaseMessage();
        messages.getBaseMessage().add(sendEmailMessage);
        try {
            List<Result> results = this.getService().execute(messages).getResult();
            for (Result result : results) {
                if (result.isSuccess()) continue;
                throw new ClarizenRuntimeException(result.getError().getErrorCode(), result.getError().getMessage());
            }
        }
        catch (IClarizenExecuteSessionTimeoutFailureFaultFaultMessage e) {
            throw new ClarizenSessionTimeoutException(e.getMessage());
        }
        return true;
    }

    public ConvertUtilsBean getConvertUtilsBean() {
        return this.convertUtilsBean;
    }

    public ClarizenDateConverter getXmlGregorianCalendarConverter() {
        return this.clarizenDateConverter;
    }

    public void setConvertUtilsBean(ConvertUtilsBean convertUtilsBean) {
        this.convertUtilsBean = convertUtilsBean;
    }

    public void setXmlGregorianCalendarConverter(ClarizenDateConverter xmlGregorianCalendarConverter) {
        this.clarizenDateConverter = xmlGregorianCalendarConverter;
    }
}

