/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.clarizen.api;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public class ClarizenDateConverter
extends AbstractConverter {
    private String[] patterns;
    private String displayPatterns;
    private Locale locale;
    private TimeZone timeZone;
    private boolean useLocaleFormat;

    public String getDisplayPatterns() {
        return this.displayPatterns;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isUseLocaleFormat() {
        return this.useLocaleFormat;
    }

    public void setDisplayPatterns(String displayPatterns) {
        this.displayPatterns = displayPatterns;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public ClarizenDateConverter() {
    }

    public ClarizenDateConverter(Object defaultValue) {
        super(defaultValue);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
        if (patterns != null && patterns.length > 1) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < patterns.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(patterns[i]);
            }
            this.displayPatterns = buffer.toString();
        }
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected Object convertToType(Class targetType, Object value) throws Exception {
        Class<?> sourceType = value.getClass();
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)value;
            return this.toDate(targetType, gregorianCalendar.toGregorianCalendar().getTime().getTime());
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return this.toDate(targetType, timeInMillis += (long)(timestamp.getNanos() / 1000000));
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return this.toDate(targetType, date.getTime());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        if (value instanceof Long) {
            Long longObj = (Long)value;
            return this.toDate(targetType, longObj);
        }
        String stringValue = value.toString().trim();
        if (stringValue.length() == 0) {
            return this.handleMissing(targetType);
        }
        if (this.useLocaleFormat) {
            Calendar calendar = null;
            if (this.patterns != null && this.patterns.length > 0) {
                calendar = this.parse(sourceType, targetType, stringValue);
            } else {
                DateFormat format = this.getFormat(this.locale, this.timeZone);
                calendar = this.parse(sourceType, targetType, stringValue, format);
            }
            if (Calendar.class.isAssignableFrom(targetType)) {
                return calendar;
            }
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        return this.toDate(targetType, stringValue);
    }

    private Object toDate(Class type, long value) {
        if (type.equals(Date.class)) {
            return new Date(value);
        }
        if (type.equals(java.sql.Date.class)) {
            return new java.sql.Date(value);
        }
        if (type.equals(Time.class)) {
            return new Time(value);
        }
        if (type.equals(Timestamp.class)) {
            return new Timestamp(value);
        }
        if (type.equals(Calendar.class)) {
            Calendar calendar = null;
            calendar = this.locale == null && this.timeZone == null ? Calendar.getInstance() : (this.locale == null ? Calendar.getInstance(this.timeZone) : (this.timeZone == null ? Calendar.getInstance(this.locale) : Calendar.getInstance(this.timeZone, this.locale)));
            calendar.setTime(new Date(value));
            calendar.setLenient(false);
            return calendar;
        }
        String msg = this.classToString(((Object)((Object)this)).getClass()) + " cannot handle conversion to '" + this.classToString(type) + "'";
        throw new ConversionException(msg);
    }

    private Object toDate(Class type, String value) {
        if (type.equals(java.sql.Date.class)) {
            try {
                return java.sql.Date.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date");
            }
        }
        if (type.equals(Time.class)) {
            try {
                return Time.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time");
            }
        }
        if (type.equals(Timestamp.class)) {
            try {
                return Timestamp.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp");
            }
        }
        String msg = this.classToString(((Object)((Object)this)).getClass()) + " does not support default String to '" + this.classToString(type) + "' conversion.";
        throw new ConversionException(msg);
    }

    protected DateFormat getFormat(Locale locale, TimeZone timeZone) {
        DateFormat format = null;
        format = locale == null ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(3, locale);
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format;
    }

    private DateFormat getFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (this.timeZone != null) {
            format.setTimeZone(this.timeZone);
        }
        return format;
    }

    private Calendar parse(Class sourceType, Class targetType, String value) throws Exception {
        Exception firstEx = null;
        for (int i = 0; i < this.patterns.length; ++i) {
            try {
                DateFormat format = this.getFormat(this.patterns[i]);
                Calendar calendar = this.parse(sourceType, targetType, value, format);
                return calendar;
            }
            catch (Exception ex) {
                if (firstEx != null) continue;
                firstEx = ex;
                continue;
            }
        }
        if (this.patterns.length > 1) {
            throw new ConversionException("Error converting '" + this.classToString(sourceType) + "' to '" + this.classToString(targetType) + "' using  patterns '" + this.displayPatterns + "'");
        }
        throw firstEx;
    }

    private Calendar parse(Class sourceType, Class targetType, String value, DateFormat format) {
        format.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        Date parsedDate = format.parse(value, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != value.length() || parsedDate == null) {
            String msg = "Error converting '" + this.classToString(sourceType) + "' to '" + this.classToString(targetType) + "'";
            if (format instanceof SimpleDateFormat) {
                msg = msg + " using pattern '" + ((SimpleDateFormat)format).toPattern() + "'";
            }
            throw new ConversionException(msg);
        }
        Calendar calendar = format.getCalendar();
        return calendar;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.classToString(((Object)((Object)this)).getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", UseLocaleFormat=");
        buffer.append(this.useLocaleFormat);
        if (this.displayPatterns != null) {
            buffer.append(", Patterns={");
            buffer.append(this.displayPatterns);
            buffer.append('}');
        }
        if (this.locale != null) {
            buffer.append(", Locale=");
            buffer.append(this.locale);
        }
        if (this.timeZone != null) {
            buffer.append(", TimeZone=");
            buffer.append(this.timeZone);
        }
        buffer.append(']');
        return buffer.toString();
    }

    protected Class<?> getDefaultType() {
        return XMLGregorianCalendar.class;
    }

    public String classToString(Class type) {
        String typeName = null;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        }
        return typeName;
    }
}

