/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.clarizen.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.clarizen.adapters.ClarizenConnectorConnectionIdentifierAdapter;
import org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionKey;
import org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClarizenConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(ClarizenConnectorConnectionFactory.class);
    private ClarizenConnectorConnectionManager connectionManager;

    public ClarizenConnectorConnectionFactory(ClarizenConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof ClarizenConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        ClarizenConnectorConnectionIdentifierAdapter connector = new ClarizenConnectorConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((ClarizenConnectorConnectionKey)key).getConnectionUser(), ((ClarizenConnectorConnectionKey)key).getConnectionPassword(), ((ClarizenConnectorConnectionKey)key).getApplicationId(), ((ClarizenConnectorConnectionKey)key).getPartnerId());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof ClarizenConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof ClarizenConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.clarizen.adapters.ClarizenConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((ClarizenConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((ClarizenConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((ClarizenConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof ClarizenConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.clarizen.adapters.ClarizenConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((ClarizenConnectorConnectionIdentifierAdapter)obj).validateConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof ClarizenConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof ClarizenConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((ClarizenConnectorConnectionIdentifierAdapter)obj).validateConnection()) {
            ((ClarizenConnectorConnectionIdentifierAdapter)obj).connect(((ClarizenConnectorConnectionKey)key).getConnectionUser(), ((ClarizenConnectorConnectionKey)key).getConnectionPassword(), ((ClarizenConnectorConnectionKey)key).getApplicationId(), ((ClarizenConnectorConnectionKey)key).getPartnerId());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

