/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.clarizen.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.clarizen.adapters.ClarizenConnectorConnectionIdentifierAdapter;
import org.mule.modules.clarizen.basic.Capabilities;
import org.mule.modules.clarizen.basic.Capability;
import org.mule.modules.clarizen.basic.MetadataAware;
import org.mule.modules.clarizen.connection.ConnectionManager;
import org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionFactory;
import org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionKey;
import org.mule.modules.clarizen.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.clarizen.process.ProcessAdapter;
import org.mule.modules.clarizen.process.ProcessTemplate;

public class ClarizenConnectorConnectionManager
implements MuleContextAware,
Initialisable,
Capabilities,
MetadataAware,
ConnectionManager<ClarizenConnectorConnectionKey, ClarizenConnectorConnectionIdentifierAdapter>,
ProcessAdapter<ClarizenConnectorConnectionIdentifierAdapter> {
    private String connectionUser;
    private String connectionPassword;
    private String applicationId;
    private String partnerId;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Clarizen";
    private static final String MODULE_VERSION = "2.0-SNAPSHOT";
    private static final String DEVKIT_VERSION = "3.4.0";
    private static final String DEVKIT_BUILD = "UNKNOWN_BUILDNUMBER";

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setConnectionUser(String value) {
        this.connectionUser = value;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public void setConnectionPassword(String value) {
        this.connectionPassword = value;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setPartnerId(String value) {
        this.partnerId = value;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setApplicationId(String value) {
        this.applicationId = value;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new ClarizenConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    @Override
    public ClarizenConnectorConnectionIdentifierAdapter acquireConnection(ClarizenConnectorConnectionKey key) throws Exception {
        return (ClarizenConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ClarizenConnectorConnectionKey key, ClarizenConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ClarizenConnectorConnectionKey key, ClarizenConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, ClarizenConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public ClarizenConnectorConnectionKey getDefaultConnectionKey() {
        return new ClarizenConnectorConnectionKey(this.getConnectionUser(), this.getConnectionPassword(), this.getApplicationId(), this.getPartnerId());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

