/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.clarizen.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.clarizen.adapters.ClarizenConnectorConnectionIdentifierAdapter;
import org.mule.modules.clarizen.connection.ConnectionManager;
import org.mule.modules.clarizen.connection.UnableToAcquireConnectionException;
import org.mule.modules.clarizen.connection.UnableToReleaseConnectionException;
import org.mule.modules.clarizen.connectivity.ClarizenConnectorConnectionKey;
import org.mule.modules.clarizen.process.ProcessCallback;
import org.mule.modules.clarizen.process.ProcessInterceptor;
import org.mule.modules.clarizen.processors.AbstractConnectedProcessor;
import org.mule.modules.clarizen.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, ClarizenConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<ClarizenConnectorConnectionKey, ClarizenConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, ClarizenConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, ClarizenConnectorConnectionIdentifierAdapter> next, ConnectionManager<ClarizenConnectorConnectionKey, ClarizenConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, ClarizenConnectorConnectionIdentifierAdapter> processCallback, ClarizenConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedConnectionUser;
        ClarizenConnectorConnectionIdentifierAdapter connection = null;
        ClarizenConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getConnectionUser() != null) {
            _transformedConnectionUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionUser());
            if (_transformedConnectionUser == null) {
                throw new UnableToAcquireConnectionException("Parameter connectionUser in method connect can't be null because is not @Optional");
            }
            String _transformedConnectionPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionPasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionPassword());
            if (_transformedConnectionPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter connectionPassword in method connect can't be null because is not @Optional");
            }
            String _transformedApplicationId = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_applicationIdType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getApplicationId());
            String _transformedPartnerId = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_partnerIdType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPartnerId());
            key = new ClarizenConnectorConnectionKey(_transformedConnectionUser, _transformedConnectionPassword, _transformedApplicationId, _transformedPartnerId);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedConnectionUser = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedConnectionUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, ClarizenConnectorConnectionIdentifierAdapter> processCallback, ClarizenConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

