/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.config.i18n.LocaleMessageHandler;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class CxfBasicTestCase
extends AbstractServiceAndFlowTestCase {
    private String echoWsdl;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfBasicTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "basic-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "basic-conf-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.echoWsdl = IOUtils.getResourceAsString((String)"cxf-echo-service.wsdl", ((Object)((Object)this)).getClass());
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            XMLUnit.getTransformerFactory();
        }
        catch (TransformerFactoryConfigurationError e) {
            XMLUnit.setTransformerFactory((String)"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        }
    }

    @Test
    public void testEchoService() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/soap+xml");
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("httpInbound")).getAddress(), (Object)xml, props);
        Assert.assertTrue((boolean)result.getPayloadAsString().contains("Hello!"));
        String ct = result.getStringProperty("Content-Type", "");
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)ct);
    }

    @Test
    public void testEchoServiceEncoding() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        String message = LocaleMessageHandler.getString((String)"test-data", (Locale)Locale.JAPAN, (String)"CxfBasicTestCase.testEchoServiceEncoding", (Object[])new Object[0]);
        MuleMessage result = client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("httpInbound")).getAddress() + "?method=echo", (Object)message, null);
        String ct = result.getStringProperty("Content-Type", "");
        Assert.assertEquals((Object)message, (Object)result.getPayload());
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)ct);
    }

    @Test
    public void testEchoWsdl() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.request(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("httpInbound")).getAddress() + "?wsdl", 5000L);
        Assert.assertNotNull((Object)result.getPayload());
        XMLUnit.compareXML((String)this.echoWsdl, (String)result.getPayloadAsString());
    }
}

