/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Map;
import javax.xml.ws.Holder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;

public class HolderTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "holder-conf.xml";
    }

    @Test
    public void testClientEchoHolder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://echoClient", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])received.getPayload();
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals((Object)"one-holder1", (Object)((Holder)payload[2]).value);
        Assert.assertEquals((Object)"one-holder2", (Object)((Holder)payload[3]).value);
    }

    @Test
    public void testClientProxyEchoHolder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://echoClientProxy", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])received.getPayload();
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals((Object)"one-holder1", (Object)((Holder)payload[1]).value);
        Assert.assertEquals((Object)"one-holder2", (Object)((Holder)payload[2]).value);
    }

    @Test
    public void testClientProxyEcho2Holder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://echo2ClientProxy", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])received.getPayload();
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals((Object)"two-holder", (Object)((Holder)payload[1]).value);
    }

    @Test
    public void testClientProxyEcho3Holder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://echo3ClientProxy", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])received.getPayload();
        Assert.assertEquals(null, (Object)payload[0]);
        Assert.assertEquals((Object)"one", (Object)((Holder)payload[1]).value);
    }

    public static class HolderTransformer3
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            Holder outS1 = new Holder();
            Object[] objArray = new Object[]{outS1, "one"};
            return objArray;
        }
    }

    public static class HolderTransformer2
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            Holder outS1 = new Holder();
            Object[] objArray = new Object[]{"one", outS1, "two"};
            return objArray;
        }
    }

    public static class HolderTransformer
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            Holder outS1 = new Holder();
            Holder outS2 = new Holder();
            Object[] objArray = new Object[]{"one", outS1, outS2};
            return objArray;
        }
    }
}

