/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.message.ExceptionMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;

public class CxfClientExceptionStrategyTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "cxf-client-exception-strategy-flow.xml";
    }

    @Test
    public void testCxfClientExceptionStrategy() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("vm://helloClient", (MuleMessage)request);
        MuleMessage out = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)out);
        Assert.assertTrue((boolean)(out.getPayload() instanceof ExceptionMessage));
        Assert.assertTrue((boolean)((String)((ExceptionMessage)out.getPayload()).getPayload()).contains("APPEND"));
    }

    public static class ThrowExceptionTransformer
    extends AbstractTransformer {
        public MuleEvent process(MuleEvent event) throws MuleException {
            throw new MessagingException(event, new Throwable("Error transforming message"));
        }

        protected Object doTransform(Object src, String enc) throws TransformerException {
            return src;
        }
    }
}

