/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfContentTypeTestCase
extends FunctionalTestCase {
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "cxf-echo-service-conf.xml";
    }

    @Test
    public void testCxfService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/hello", (MuleMessage)request);
        String contentType = (String)received.getInboundProperty("content-type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.contains("charset"));
    }

    @Test
    public void testCxfClient() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://helloClient", (MuleMessage)request);
        String contentType = (String)received.getInboundProperty("contentType");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.contains("charset"));
    }
}

