/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.service.model.EndpointInfo;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.service.Service;
import org.mule.construct.Flow;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.config.FlowConfiguringMessageProcessor;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class EndpointBindsToCorrectWdslPortTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public EndpointBindsToCorrectWdslPortTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/module/cxf/functional/endpoint-binds-to-correct-wdsl-port-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/module/cxf/functional/endpoint-binds-to-correct-wdsl-port-flow.xml"});
    }

    @Test
    public void testThatTheCorrectSoapPortIsChosen() throws Exception {
        DefaultInboundEndpoint inboundEndpoint;
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            Flow flow = (Flow)muleContext.getRegistry().lookupObject("CXFProxyService");
            inboundEndpoint = (DefaultInboundEndpoint)flow.getMessageSource();
        } else {
            Service service = muleContext.getRegistry().lookupService("CXFProxyService");
            ServiceCompositeMessageSource messageSource = (ServiceCompositeMessageSource)service.getMessageSource();
            List endpoints = messageSource.getEndpoints();
            inboundEndpoint = (DefaultInboundEndpoint)endpoints.get(0);
        }
        List processors = inboundEndpoint.getMessageProcessors();
        FlowConfiguringMessageProcessor wrapper = (FlowConfiguringMessageProcessor)processors.get(0);
        CxfInboundMessageProcessor cxfProcessor = (CxfInboundMessageProcessor)wrapper.getWrappedMessageProcessor();
        Server server = cxfProcessor.getServer();
        EndpointInfo endpointInfo = server.getEndpoint().getEndpointInfo();
        Assert.assertEquals((String)"The local part of the endpoing name must be the one supplied as the endpointName parameter on the cxf:inbound-endpoint", (Object)"ListsSoap", (Object)endpointInfo.getName().getLocalPart());
    }
}

