/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.issues;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;
import org.mule.util.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProxyServiceServingWsdlMule4092TestCase
extends AbstractServiceAndFlowTestCase {
    private String expectedWsdlFileName;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public ProxyServiceServingWsdlMule4092TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "issues/proxy-service-serving-wsdl-mule4092-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "issues/proxy-service-serving-wsdl-mule4092-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.setupExpectedWsdlFileName();
    }

    private void setupExpectedWsdlFileName() {
        if (SystemUtils.isSunJDK() || SystemUtils.isAppleJDK()) {
            this.expectedWsdlFileName = "test.wsdl";
        } else if (SystemUtils.isIbmJDK()) {
            this.expectedWsdlFileName = SystemUtils.isJavaVersionAtLeast((int)160) ? "test.wsdl.ibmjdk-6" : "test.wsdl.ibmjdk-5";
        } else {
            Assert.fail((String)"Unknown JDK");
        }
    }

    @Test
    public void testProxyServiceWSDL() throws Exception {
        String expected = this.getXML("issues/" + this.expectedWsdlFileName);
        URL url = new URL("http://localhost:" + this.dynamicPort.getNumber() + "/services/onlinestore?wsdl");
        String wsdlFromService = IOUtils.toString((InputStream)url.openStream());
        Document expectedDom = this.buildDOM(expected);
        Document actualDom = this.buildDOM(wsdlFromService);
        Element topElement = expectedDom.getDocumentElement();
        String wsdlNamespace = topElement.getNamespaceURI();
        Assert.assertEquals((Object)wsdlNamespace, (Object)actualDom.getDocumentElement().getNamespaceURI());
        Assert.assertEquals((Object)topElement.getLocalName(), (Object)actualDom.getDocumentElement().getLocalName());
        Element expectedService = (Element)expectedDom.getElementsByTagNameNS(wsdlNamespace, "service").item(0);
        Element actualService = (Element)actualDom.getElementsByTagNameNS(wsdlNamespace, "service").item(0);
        Assert.assertNotNull((Object)actualService);
        Assert.assertEquals((Object)expectedService.getAttribute("name"), (Object)actualService.getAttribute("name"));
        Element expectedPort = (Element)expectedDom.getElementsByTagNameNS(wsdlNamespace, "port").item(0);
        Element actualPort = (Element)actualDom.getElementsByTagNameNS(wsdlNamespace, "port").item(0);
        Assert.assertNotNull((Object)actualPort);
        Assert.assertEquals((Object)expectedPort.getAttribute("name"), (Object)actualPort.getAttribute("name"));
        int expectedNumberOfMessages = expectedDom.getElementsByTagNameNS(wsdlNamespace, "message").getLength();
        int actualNumberOfmMessages = actualDom.getElementsByTagNameNS(wsdlNamespace, "message").getLength();
        Assert.assertEquals((long)expectedNumberOfMessages, (long)actualNumberOfmMessages);
    }

    protected String getXML(String requestFile) throws Exception {
        String xml = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)requestFile, ((Object)((Object)this)).getClass()), (String)"UTF-8");
        if (xml != null) {
            return xml;
        }
        Assert.fail((String)"Unable to load test request file");
        return null;
    }

    private Document buildDOM(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource source = new InputSource(new StringReader(xmlString));
        return builder.parse(source);
    }
}

