/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.exception.TemplateMessagingExceptionStrategy;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;

public class CatchExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    private static final String requestFaultPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CatchExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "catch-exception-strategy-service-conf.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "catch-exception-strategy-flow-conf.xml"});
    }

    @Test
    public void testFaultInCxfServiceWithCatchExceptionStrategy() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestFaultPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testServiceWithFaultCatchException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)String.valueOf(200), (Object)response.getInboundProperty("http.status"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("Anonymous"));
    }

    @Test
    public void testFaultInCxfServiceWithCatchExceptionStrategyRethrown() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestFaultPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testServiceWithFaultCatchExceptionRethrown", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
    }

    @Test
    public void testExceptionThrownInTransformerWithCatchExceptionStrategy() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testTransformerExceptionCatchException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)String.valueOf(200), (Object)response.getInboundProperty("http.status"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("APPEND"));
    }

    @Test
    public void testClientWithSOAPFaultCatchException() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("vm://testClientSOAPFaultCatchException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.getExceptionPayload() == null ? 1 : 0) != 0);
    }

    @Test
    public void testClientWithSOAPFaultCatchExceptionRedirect() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("vm://testClientSOAPFaultCatchExceptionRedirect", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("TEST"));
        Assert.assertTrue((response.getExceptionPayload() == null ? 1 : 0) != 0);
    }

    @Test
    public void testClientWithTransformerExceptionCatchException() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("vm://testClientTransformerExceptionCatchException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains(" Anonymous"));
    }

    @Test
    public void testServerClientProxyWithTransformerExceptionCatchStrategy() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testProxyWithTransformerExceptionCatchStrategy", (Object)requestPayload, null);
        String resString = result.getPayloadAsString();
        Assert.assertEquals((Object)String.valueOf(200), (Object)result.getInboundProperty("http.status"));
        Assert.assertTrue((boolean)resString.contains("Anonymous"));
    }

    public static class CxfTransformerThrowsExceptions
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            throw new TransformerException(CoreMessages.failedToBuildMessage());
        }
    }

    public static class RethrowExceptionStrategy
    extends TemplateMessagingExceptionStrategy {
        protected void nullifyExceptionPayloadIfRequired(MuleEvent event) {
        }

        protected MuleEvent afterRouting(Exception exception, MuleEvent event) {
            return event;
        }

        protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
            return event;
        }
    }

    public static class RethrowFaultProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            throw new Fault(event.getMessage().getExceptionPayload().getException().getCause());
        }
    }

    public static class ProxyCustomProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            String payload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:sayHiResponse xmlns:ns2=\"http://example.cxf.module.mule.org/\"><return>Hello Anonymous</return></ns2:sayHiResponse></soap:Body></soap:Envelope>";
            event.getMessage().setPayload((Object)payload);
            return event;
        }
    }
}

