/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.config.FlowConfiguringMessageProcessor;
import org.mule.module.cxf.config.ProxyServiceFactoryBean;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ConfigurationTestCase
extends AbstractServiceAndFlowTestCase {
    public ConfigurationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "configuration-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "configuration-conf-flow.xml"});
    }

    @Test
    public void testBusConfiguration() throws Exception {
        CxfConfiguration config = (CxfConfiguration)muleContext.getRegistry().get("cxf");
        Bus cxfBus = config.getCxfBus();
        boolean found = false;
        for (Interceptor i : cxfBus.getInInterceptors()) {
            if (!(i instanceof LoggingInInterceptor)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Did not find logging interceptor.", (boolean)found);
    }

    @Test
    public void testSpringRefs() throws Exception {
        InboundEndpoint endpoint = (InboundEndpoint)muleContext.getRegistry().get("clientEndpoint");
        FlowConfiguringMessageProcessor processor = (FlowConfiguringMessageProcessor)endpoint.getMessageProcessors().get(0);
        List inInterceptors = ((ProxyServiceFactoryBean)processor.getMessageProcessorBuilder()).getInInterceptors();
        Assert.assertEquals((Object)muleContext.getRegistry().get("foo1"), inInterceptors.get(0));
        Assert.assertEquals((Object)muleContext.getRegistry().get("foo3"), inInterceptors.get(1));
    }
}

