/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.apache.cxf.interceptor.Fault;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.module.client.MuleClient;
import org.mule.module.cxf.testmodels.CustomFault;
import org.mule.module.cxf.testmodels.CxfEnabledFaultMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfComponentExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfComponentExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "exception-strategy-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "exception-strategy-conf-flow.xml"});
    }

    @Test
    public void testDefaultComponentExceptionStrategyWithFault() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        try {
            client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfExceptionStrategyInbound")).getAddress() + "?method=testFault", (Object)"TEST", null);
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof Fault));
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Invalid data argument"));
        }
    }

    @Test
    public void testDefaultExceptionStrategyWithFault() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        try {
            client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfDefaultExceptionStrategyInbound")).getAddress() + "?method=testFault", (Object)"TEST", null);
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof Fault));
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Invalid data argument"));
        }
    }

    @Test
    public void testDefaultComponentExceptionStrategyWithCxfException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        try {
            client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfExceptionStrategyInbound")).getAddress() + "?method=testCxfException", (Object)"TEST", null);
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Throwable t = e.getCause();
            Assert.assertTrue((boolean)(t instanceof CxfEnabledFaultMessage));
            CustomFault fault = ((CxfEnabledFaultMessage)((Object)t)).getFaultInfo();
            Assert.assertNotNull((Object)fault);
            Assert.assertEquals((Object)"Custom Exception Message", (Object)fault.getDescription());
        }
    }

    @Test
    public void testDefaultExceptionStrategyWithCxfException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        try {
            client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfDefaultExceptionStrategyInbound")).getAddress() + "?method=testCxfException", (Object)"TEST", null);
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Throwable t = e.getCause();
            Assert.assertTrue((boolean)(t instanceof CxfEnabledFaultMessage));
            CustomFault fault = ((CxfEnabledFaultMessage)((Object)t)).getFaultInfo();
            Assert.assertNotNull((Object)fault);
            Assert.assertEquals((Object)"Custom Exception Message", (Object)fault.getDescription());
        }
    }

    @Test
    public void testDefaultComponentExceptionStrategyWithException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        try {
            client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfExceptionStrategyInbound")).getAddress() + "?method=testNonCxfException", (Object)"TEST", null);
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof Fault));
        }
    }

    @Test
    public void testDefaultExceptionStrategyWithException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        try {
            client.send("cxf:" + ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfDefaultExceptionStrategyInbound")).getAddress() + "?method=testNonCxfException", (Object)"TEST", null);
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof Fault));
        }
    }
}

