/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfDynamicEndpointTestCase
extends FunctionalTestCase {
    public static final String SAMPLE_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    private static int invocationCount = 0;
    @Rule
    public DynamicPort port = new DynamicPort("httpPort");

    protected String getConfigResources() {
        return "cxf-dynamic-endpoint-config.xml";
    }

    @Before
    public void setUp() throws Exception {
        invocationCount = 0;
    }

    @Test
    public void sendsCorrectNotificationsWithCxfInsideEndpoint() throws Exception {
        this.doTest("http://localhost:" + this.port.getValue() + "/cxfInsideEndpoint");
    }

    @Test
    public void sendsCorrectNotificationsWithCxfOutsideEndpoint() throws Exception {
        this.doTest("http://localhost:" + this.port.getValue() + "/cxfOutsideEndpoint");
    }

    private void doTest(String url) throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("DYNAMIC_PATH", "path1");
        client.send(url, (Object)SAMPLE_REQUEST, messageProperties);
        messageProperties.put("DYNAMIC_PATH", "path2");
        client.send(url, (Object)SAMPLE_REQUEST, messageProperties);
        messageProperties.put("DYNAMIC_PATH", "path1");
        client.send(url, (Object)SAMPLE_REQUEST, messageProperties);
        Assert.assertEquals((long)2L, (long)invocationCount);
    }

    public static class EndpointMetricsNotification
    implements EndpointMessageNotificationListener<EndpointMessageNotification> {
        public void onNotification(EndpointMessageNotification notification) {
            if (notification.getAction() == 852 && notification.getEndpoint().endsWith("path1")) {
                invocationCount++;
            }
        }
    }
}

